/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.order.InstrumentType;
import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.OrderBuilder;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.OrderWithTpSlBuilder;
import io.github.hyperliquid.sdk.model.order.Tif;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;

public class OrderRequest {
    private InstrumentType instrumentType;
    private String coin;
    private Boolean isBuy;
    private Double sz;
    private Double limitPx;
    private OrderType orderType;
    private Boolean reduceOnly;
    private Cloid cloid;
    private Double slippage = 0.05;
    private Long expiresAfter;

    public OrderRequest() {
    }

    public OrderRequest(InstrumentType instrumentType, String coin, Boolean isBuy, Double sz, Double limitPx, OrderType orderType, Boolean reduceOnly, Cloid cloid) {
        this.instrumentType = instrumentType;
        this.coin = coin;
        this.isBuy = isBuy;
        this.sz = sz;
        this.limitPx = limitPx;
        this.orderType = orderType;
        this.reduceOnly = reduceOnly;
        this.cloid = cloid;
    }

    public OrderRequest(InstrumentType instrumentType, String coin, Boolean isBuy, Double sz, Double limitPx, OrderType orderType, Boolean reduceOnly, Cloid cloid, Double slippage) {
        this.instrumentType = instrumentType;
        this.coin = coin;
        this.isBuy = isBuy;
        this.sz = sz;
        this.limitPx = limitPx;
        this.orderType = orderType;
        this.reduceOnly = reduceOnly;
        this.cloid = cloid;
        this.slippage = slippage;
    }

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    public static OrderWithTpSlBuilder entryWithTpSl() {
        return new OrderWithTpSlBuilder();
    }

    public InstrumentType getInstrumentType() {
        return this.instrumentType;
    }

    public void setInstrumentType(InstrumentType instrumentType) {
        this.instrumentType = instrumentType;
    }

    public String getCoin() {
        return this.coin;
    }

    public void setCoin(String coin) {
        this.coin = coin;
    }

    public Boolean getIsBuy() {
        return this.isBuy;
    }

    public void setIsBuy(Boolean isBuy) {
        this.isBuy = isBuy;
    }

    public Double getSz() {
        return this.sz;
    }

    public void setSz(Double sz) {
        this.sz = sz;
    }

    public Double getLimitPx() {
        return this.limitPx;
    }

    public void setLimitPx(Double limitPx) {
        this.limitPx = limitPx;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public Boolean getReduceOnly() {
        return this.reduceOnly;
    }

    public void setReduceOnly(Boolean reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    public Cloid getCloid() {
        return this.cloid;
    }

    public void setCloid(Cloid cloid) {
        this.cloid = cloid;
    }

    public Double getSlippage() {
        return this.slippage;
    }

    public void setSlippage(Double slippage) {
        this.slippage = slippage;
    }

    public Long getExpiresAfter() {
        return this.expiresAfter;
    }

    public void setExpiresAfter(Long expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public static class Close {
        public static OrderRequest market(String coin, Double sz, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setSz(sz);
            req.setReduceOnly(true);
            req.setCloid(cloid);
            LimitOrderType limitOrderType = new LimitOrderType(Tif.IOC);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest market(String coin, boolean isBuy, double sz, Cloid cloid) {
            OrderRequest req = Close.market(coin, sz, cloid);
            req.setIsBuy(isBuy);
            return req;
        }

        public static OrderRequest positionAtMarketAll(String coin) {
            return Close.market(coin, null, null);
        }

        public static OrderRequest limit(Tif tif, String coin, double sz, double limitPx, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(null);
            req.setSz(sz);
            req.setLimitPx(limitPx);
            req.setReduceOnly(true);
            req.setCloid(cloid);
            LimitOrderType limitOrderType = new LimitOrderType(tif);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }
    }

    public static class Open {
        public static OrderRequest market(String coin, boolean isBuy, double sz) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setReduceOnly(false);
            LimitOrderType limitOrderType = new LimitOrderType(Tif.IOC);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest limit(Tif tif, String coin, boolean isBuy, double sz, double limitPx) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(limitPx);
            req.setReduceOnly(false);
            LimitOrderType limitOrderType = new LimitOrderType(tif);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest trigger(String coin, boolean isBuy, double sz, double triggerPx, Double limitPx, boolean isMarket, TriggerOrderType.TpslType tpsl) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(limitPx);
            req.setReduceOnly(false);
            TriggerOrderType triggerOrderType = new TriggerOrderType(triggerPx, isMarket, tpsl);
            OrderType orderType = new OrderType(triggerOrderType);
            req.setOrderType(orderType);
            return req;
        }
    }
}

