/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.order.GroupingType;
import io.github.hyperliquid.sdk.model.order.InstrumentType;
import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.OrderGroup;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.Tif;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;
import java.util.ArrayList;
import java.util.List;

public class OrderWithTpSlBuilder {
    private InstrumentType instrumentType;
    private String coin;
    private Boolean isBuy;
    private Double sz;
    private Double entryPrice;
    private Double takeProfitPrice;
    private Double stopLossPrice;
    private Tif entryTif = Tif.GTC;
    private Cloid cloid;
    private Long expiresAfter;

    public OrderWithTpSlBuilder expiresAfter(Long expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public OrderWithTpSlBuilder perp(String coin) {
        this.instrumentType = InstrumentType.PERP;
        this.coin = coin;
        return this;
    }

    public OrderWithTpSlBuilder spot(String coin) {
        this.instrumentType = InstrumentType.SPOT;
        this.coin = coin;
        return this;
    }

    public OrderWithTpSlBuilder buy(Double sz) {
        this.isBuy = true;
        this.sz = sz;
        return this;
    }

    public OrderWithTpSlBuilder sell(Double sz) {
        this.isBuy = false;
        this.sz = sz;
        return this;
    }

    public OrderWithTpSlBuilder closePosition(Double sz, boolean isLongPosition) {
        this.isBuy = isLongPosition;
        this.sz = sz;
        this.entryPrice = null;
        return this;
    }

    public OrderWithTpSlBuilder entryPrice(Double entryPrice) {
        this.entryPrice = entryPrice;
        return this;
    }

    public OrderWithTpSlBuilder takeProfit(Double tpPrice) {
        this.takeProfitPrice = tpPrice;
        return this;
    }

    public OrderWithTpSlBuilder stopLoss(Double slPrice) {
        this.stopLossPrice = slPrice;
        return this;
    }

    public OrderWithTpSlBuilder entryTif(Tif tif) {
        this.entryTif = tif;
        return this;
    }

    public OrderWithTpSlBuilder cloid(Cloid cloid) {
        this.cloid = cloid;
        return this;
    }

    public OrderGroup buildNormalTpsl() {
        return new OrderGroup(this.buildOrderList(true), GroupingType.NORMAL_TPSL);
    }

    public OrderGroup buildPositionTpsl() {
        return new OrderGroup(this.buildOrderList(false), GroupingType.POSITION_TPSL);
    }

    private List<OrderRequest> buildOrderList(boolean includeEntry) {
        this.validate();
        ArrayList<OrderRequest> orders = new ArrayList<OrderRequest>();
        if (includeEntry) {
            OrderRequest entry;
            if (this.entryPrice == null) {
                entry = new OrderRequest();
                entry.setInstrumentType(this.instrumentType != null ? this.instrumentType : InstrumentType.PERP);
                entry.setCoin(this.coin);
                entry.setIsBuy(this.isBuy);
                entry.setSz(this.sz);
                entry.setReduceOnly(false);
                entry.setCloid(this.cloid);
                LimitOrderType limitOrderType = new LimitOrderType(Tif.IOC);
                OrderType orderType = new OrderType(limitOrderType);
                entry.setOrderType(orderType);
            } else {
                entry = new OrderRequest(this.instrumentType != null ? this.instrumentType : InstrumentType.PERP, this.coin, this.isBuy, this.sz, this.entryPrice, new OrderType(new LimitOrderType(this.entryTif)), false, this.cloid);
            }
            if (this.expiresAfter != null) {
                entry.setExpiresAfter(this.expiresAfter);
            }
            orders.add(entry);
        }
        if (this.takeProfitPrice != null) {
            OrderRequest tp = new OrderRequest(this.instrumentType != null ? this.instrumentType : InstrumentType.PERP, this.coin, this.isBuy == false, this.sz, this.takeProfitPrice, new OrderType(new TriggerOrderType(this.takeProfitPrice, true, TriggerOrderType.TpslType.TP)), true, null);
            if (this.expiresAfter != null) {
                tp.setExpiresAfter(this.expiresAfter);
            }
            orders.add(tp);
        }
        if (this.stopLossPrice != null) {
            OrderRequest sl = new OrderRequest(this.instrumentType != null ? this.instrumentType : InstrumentType.PERP, this.coin, this.isBuy == false, this.sz, this.stopLossPrice, new OrderType(new TriggerOrderType(this.stopLossPrice, true, TriggerOrderType.TpslType.SL)), true, null);
            if (this.expiresAfter != null) {
                sl.setExpiresAfter(this.expiresAfter);
            }
            orders.add(sl);
        }
        return orders;
    }

    private void validate() {
        if (this.coin == null || this.coin.isEmpty()) {
            throw new IllegalStateException("coin is required");
        }
        if (this.isBuy == null) {
            throw new IllegalStateException("direction is required (call buy(), sell(), or closePosition())");
        }
        if (this.sz == null || this.sz <= 0.0) {
            throw new IllegalStateException("size must be positive");
        }
        if (this.takeProfitPrice == null && this.stopLossPrice == null) {
            throw new IllegalStateException("at least one of takeProfit or stopLoss is required");
        }
    }
}

