/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.hyperliquid.sdk.utils.ApiError;
import io.github.hyperliquid.sdk.utils.HypeError;
import io.github.hyperliquid.sdk.utils.JSONUtil;
import io.github.hyperliquid.sdk.utils.Result;
import io.github.hyperliquid.sdk.utils.RetryPolicy;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypeHttpClient {
    private static final Logger log = LoggerFactory.getLogger(HypeHttpClient.class);
    private final String baseUrl;
    private final OkHttpClient client;
    private static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");

    public HypeHttpClient(String baseUrl, OkHttpClient client) {
        this.baseUrl = baseUrl;
        this.client = client;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public JsonNode post(String path, Object payload) {
        JsonNode jsonNode;
        block10: {
            String url = this.baseUrl + path;
            String json = "";
            json = JSONUtil.writeValueAsString(payload);
            log.debug("POST: {} ", (Object)url);
            log.debug("Request: {}", (Object)json);
            RequestBody body = RequestBody.create((String)json, (MediaType)JSON_MEDIA_TYPE);
            Request request = new Request.Builder().url(url).addHeader("Accept", "application/json").post(body).build();
            Response response = this.client.newCall(request).execute();
            try {
                String responseBody;
                String string = responseBody = response.body() != null ? response.body().string() : "{}";
                if (!response.isSuccessful()) {
                    int code = response.code();
                    String errorMsg = String.format("HTTP %d: %s", code, responseBody);
                    if (code >= 400 && code < 500) {
                        throw new HypeError.ClientHypeError(code, errorMsg);
                    }
                    throw new HypeError.ServerHypeError(code, errorMsg);
                }
                log.debug("Response: {}", (Object)responseBody);
                jsonNode = JSONUtil.readTree(responseBody);
                if (response == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Network error for POST: {} Request: {}", new Object[]{path, json, e});
                    throw new HypeError("Network error for POST " + path + ": " + e.getMessage(), e);
                }
            }
            response.close();
        }
        return jsonNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonNode postWithRetry(String path, Object payload, RetryPolicy policy) {
        String url = this.baseUrl + path;
        String json = "";
        int attempt = 0;
        long backoff = policy == null ? RetryPolicy.defaultPolicy().getInitialBackoffMillis() : policy.getInitialBackoffMillis();
        int maxRetries = policy == null ? RetryPolicy.defaultPolicy().getMaxRetries() : policy.getMaxRetries();
        double multiplier = policy == null ? RetryPolicy.defaultPolicy().getBackoffMultiplier() : policy.getBackoffMultiplier();
        long maxBackoff = policy == null ? RetryPolicy.defaultPolicy().getMaxBackoffMillis() : policy.getMaxBackoffMillis();
        while (true) {
            block14: {
                try {
                    json = JSONUtil.writeValueAsString(payload);
                    log.info("POST(retry:{}): {}", (Object)attempt, (Object)url);
                    log.debug("Request: {}", (Object)json);
                    RequestBody body = RequestBody.create((String)json, (MediaType)JSON_MEDIA_TYPE);
                    Request request = new Request.Builder().url(url).addHeader("Accept", "application/json").post(body).build();
                    try (Response response = this.client.newCall(request).execute();){
                        String responseBody;
                        String string = responseBody = response.body() != null ? response.body().string() : "{}";
                        if (response.isSuccessful()) {
                            log.debug("Response: {}", (Object)responseBody);
                            JsonNode jsonNode = JSONUtil.readTree(responseBody);
                            return jsonNode;
                        }
                        int code = response.code();
                        String errorMsg = String.format("HTTP %d: %s", code, responseBody);
                        if (code >= 400 && code < 500) {
                            log.warn("Non-retryable 4xx: {}", (Object)errorMsg);
                            throw new HypeError.ClientHypeError(code, errorMsg);
                        }
                        log.warn("Retryable 5xx: {} (attempt {}/{})", new Object[]{errorMsg, attempt + 1, maxRetries});
                        if (++attempt > maxRetries) {
                            throw new HypeError.ServerHypeError(code, errorMsg);
                        }
                    }
                }
                catch (IOException e) {
                    log.warn("Network error on attempt {}/{} for POST {}: {}", new Object[]{attempt + 1, maxRetries, path, e.toString()});
                    if (++attempt <= maxRetries) break block14;
                    log.error("Max retries exceeded for POST {}", (Object)path);
                    throw new HypeError("Network error for POST " + path + ": " + e.getMessage(), e);
                }
            }
            try {
                log.info("Backoff {} ms before next retry", (Object)backoff);
                Thread.sleep(backoff);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new HypeError("Retry interrupted for POST " + path);
            }
            backoff = Math.min((long)((double)backoff * multiplier), maxBackoff);
        }
    }

    public Result<JsonNode> postWithResult(String path, Object payload) {
        try {
            JsonNode node = this.post(path, payload);
            return Result.ok(node);
        }
        catch (HypeError.ClientHypeError e) {
            ApiError apiErr = new ApiError("HTTP_4XX", e.getMessage(), e.getStatusCode());
            return Result.err(apiErr);
        }
        catch (HypeError.ServerHypeError e) {
            ApiError apiErr = new ApiError("HTTP_5XX", e.getMessage(), e.getStatusCode());
            return Result.err(apiErr);
        }
        catch (HypeError e) {
            ApiError apiErr = new ApiError("HTTP_IO", e.getMessage());
            return Result.err(apiErr);
        }
    }
}

