/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

import io.github.hyperliquid.sdk.utils.ApiError;
import java.util.Objects;
import java.util.function.Function;

public final class Result<T> {
    private final T ok;
    private final ApiError err;

    private Result(T ok, ApiError err) {
        this.ok = ok;
        this.err = err;
    }

    public static <T> Result<T> ok(T value) {
        return new Result<T>(Objects.requireNonNull(value), null);
    }

    public static <T> Result<T> err(ApiError error) {
        return new Result<Object>(null, Objects.requireNonNull(error));
    }

    public boolean isOk() {
        return this.err == null;
    }

    public boolean isErr() {
        return this.err != null;
    }

    public T getOk() {
        return this.ok;
    }

    public ApiError getErr() {
        return this.err;
    }

    public <U> Result<U> map(Function<T, U> mapper) {
        if (this.isOk()) {
            return Result.ok(mapper.apply(this.ok));
        }
        return Result.err(this.err);
    }

    public Result<T> mapErr(Function<ApiError, ApiError> mapper) {
        if (this.isErr()) {
            return Result.err(mapper.apply(this.err));
        }
        return this;
    }
}

