/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.OrderWire;
import io.github.hyperliquid.sdk.utils.HypeError;
import io.github.hyperliquid.sdk.utils.JSONUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.crypto.StructuredDataEncoder;
import org.web3j.utils.Numeric;

public final class Signing {
    private static volatile boolean STRICT_ADDRESS_LENGTH = Boolean.TRUE;

    private Signing() {
    }

    public static String floatToWire(double value) {
        Object[] objectArray = new Object[]{value};
        String rounded = String.format(Locale.US, "%.8f", objectArray);
        double roundedDouble = Double.parseDouble(rounded);
        if (Math.abs(roundedDouble - value) >= 1.0E-12) {
            throw new IllegalArgumentException("floatToWire causes rounding: " + value);
        }
        BigDecimal normalized = new BigDecimal(rounded).stripTrailingZeros();
        String s = normalized.toPlainString();
        if ("-0".equals(s)) {
            s = "0";
        }
        return s;
    }

    public static long floatToIntForHashing(double value) {
        return Signing.floatToInt(value, 8);
    }

    public static long floatToUsdInt(double value) {
        return Signing.floatToInt(value, 6);
    }

    public static long floatToInt(double value, int power) {
        double withDecimals = value * Math.pow(10.0, power);
        double rounded = Math.rint(withDecimals);
        if (Math.abs(rounded - withDecimals) >= 0.001) {
            throw new IllegalArgumentException("floatToInt causes rounding: " + value);
        }
        return Math.round(withDecimals);
    }

    public static long getTimestampMs() {
        return System.currentTimeMillis();
    }

    public static Object orderTypeToWire(OrderType orderType) {
        if (orderType == null) {
            return null;
        }
        LinkedHashMap out = new LinkedHashMap();
        if (orderType.getLimit() != null) {
            LinkedHashMap<String, String> limitObj = new LinkedHashMap<String, String>();
            limitObj.put("tif", orderType.getLimit().getTif().getValue());
            out.put("limit", limitObj);
        }
        if (orderType.getTrigger() != null) {
            LinkedHashMap<String, Object> trigObj = new LinkedHashMap<String, Object>();
            trigObj.put("isMarket", orderType.getTrigger().isMarket());
            trigObj.put("triggerPx", Signing.floatToWire(orderType.getTrigger().getTriggerPx()));
            trigObj.put("tpsl", orderType.getTrigger().getTpsl());
            out.put("trigger", trigObj);
        }
        return out.isEmpty() ? null : out;
    }

    public static OrderWire orderRequestToOrderWire(int coinId, OrderRequest req) {
        String szStr = Signing.floatToWire(req.getSz());
        String pxStr = req.getLimitPx() == null ? null : Signing.floatToWire(req.getLimitPx());
        Object orderTypeWire = Signing.orderTypeToWire(req.getOrderType());
        return new OrderWire(coinId, req.getIsBuy(), szStr, pxStr, orderTypeWire, req.getReduceOnly(), req.getCloid());
    }

    public static byte[] actionHash(Object action, long nonce, String vaultAddress, Long expiresAfter) {
        try {
            byte[] actionMsgpack = Signing.packAsMsgpack(action);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(actionMsgpack.length + 64);
            baos.write(actionMsgpack);
            byte[] nonceBytes = ByteBuffer.allocate(8).putLong(nonce).array();
            baos.write(nonceBytes);
            if (vaultAddress == null) {
                baos.write(new byte[]{0});
            } else {
                baos.write(new byte[]{1});
                byte[] addrBytes = Signing.addressToBytes(vaultAddress);
                if (addrBytes.length != 20) {
                    throw new IllegalArgumentException("vaultAddress must be 20 bytes");
                }
                baos.write(addrBytes);
            }
            if (expiresAfter != null) {
                baos.write(new byte[]{0});
                byte[] expBytes = ByteBuffer.allocate(8).putLong(expiresAfter).array();
                baos.write(expBytes);
            }
            byte[] preimage = baos.toByteArray();
            return Hash.sha3((byte[])preimage);
        }
        catch (Exception e) {
            throw new HypeError("Failed to compute action hash: " + e.getMessage());
        }
    }

    private static byte[] packAsMsgpack(Object obj) throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        Signing.writeMsgpack(packer, obj);
        packer.close();
        return packer.toByteArray();
    }

    private static void writeMsgpack(MessageBufferPacker packer, Object obj) throws IOException {
        Object object = obj;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, List.class, String.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class, OrderWire.class}, (Object)object, n)) {
            case -1: {
                packer.packNil();
                return;
            }
            case 0: {
                Map ignored = (Map)object;
                Map map = (Map)obj;
                packer.packMapHeader(map.size());
                for (Map.Entry e : map.entrySet()) {
                    packer.packString(String.valueOf(e.getKey()));
                    Signing.writeMsgpack(packer, e.getValue());
                }
                return;
            }
            case 1: {
                List ignored = (List)object;
                List list = (List)obj;
                packer.packArrayHeader(list.size());
                for (Object o : list) {
                    Signing.writeMsgpack(packer, o);
                }
                return;
            }
            case 2: {
                String s = (String)object;
                packer.packString(s);
                return;
            }
            case 3: {
                Integer i = (Integer)object;
                packer.packInt(i.intValue());
                return;
            }
            case 4: {
                Long l = (Long)object;
                packer.packLong(l.longValue());
                return;
            }
            case 5: {
                Double v = (Double)object;
                packer.packDouble(v.doubleValue());
                return;
            }
            case 6: {
                Float v = (Float)object;
                packer.packDouble(v.doubleValue());
                return;
            }
            case 7: {
                Boolean b = (Boolean)object;
                packer.packBoolean(b.booleanValue());
                return;
            }
            case 8: {
                OrderWire ow = (OrderWire)object;
                LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
                m.put("a", ow.coin);
                m.put("b", ow.isBuy);
                if (ow.limitPx != null) {
                    m.put("p", ow.limitPx);
                }
                m.put("s", ow.sz);
                m.put("r", ow.reduceOnly);
                if (ow.orderType != null) {
                    m.put("t", ow.orderType);
                }
                if (ow.cloid != null) {
                    m.put("c", ow.cloid.getRaw());
                }
                Signing.writeMsgpack(packer, m);
                return;
            }
        }
        packer.packString(String.valueOf(obj));
    }

    public static byte[] addressToBytes(String address) {
        byte[] full;
        if (address == null) {
            throw new IllegalArgumentException("address must not be null");
        }
        String clean = Numeric.cleanHexPrefix((String)address);
        if (clean.isEmpty()) {
            throw new IllegalArgumentException("address must not be empty");
        }
        try {
            full = Numeric.hexStringToByteArray((String)clean);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("address contains non-hex characters: " + address, e);
        }
        if (STRICT_ADDRESS_LENGTH) {
            if (full.length != 20) {
                throw new IllegalArgumentException("address must be exactly 20 bytes (40 hex chars), got " + full.length + " bytes");
            }
            return full;
        }
        if (full.length > 20) {
            return Arrays.copyOfRange(full, full.length - 20, full.length);
        }
        if (full.length == 20) {
            return full;
        }
        byte[] out = new byte[20];
        System.arraycopy(full, 0, out, 20 - full.length, full.length);
        return out;
    }

    public static Map<String, Object> signTypedData(Credentials credentials, String typedDataJson) {
        try {
            StructuredDataEncoder encoder = new StructuredDataEncoder(typedDataJson);
            byte[] digest = encoder.hashStructuredData();
            Sign.SignatureData sig = Sign.signMessage((byte[])digest, (ECKeyPair)credentials.getEcKeyPair(), (boolean)false);
            String r = Numeric.toHexString((byte[])sig.getR());
            String s = Numeric.toHexString((byte[])sig.getS());
            int vInt = new BigInteger(1, sig.getV()).intValue();
            LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
            out.put("r", r);
            out.put("s", s);
            out.put("v", vInt);
            return out;
        }
        catch (Exception e) {
            throw new HypeError("Failed to sign typed data: " + e.getMessage());
        }
    }

    public static Map<String, Object> constructPhantomAgent(byte[] hash, boolean isMainnet) {
        LinkedHashMap<String, Object> agent = new LinkedHashMap<String, Object>();
        agent.put("source", isMainnet ? "a" : "b");
        agent.put("connectionId", Numeric.toHexString((byte[])hash));
        return agent;
    }

    public static String l1PayloadJson(Map<String, Object> phantomAgent) {
        LinkedHashMap<String, Object> domain = new LinkedHashMap<String, Object>();
        domain.put("chainId", 1337);
        domain.put("name", "Exchange");
        domain.put("verifyingContract", "0x0000000000000000000000000000000000000000");
        domain.put("version", "1");
        ArrayList<Map<String, String>> agentTypes = new ArrayList<Map<String, String>>();
        agentTypes.add(Map.of("name", "source", "type", "string"));
        agentTypes.add(Map.of("name", "connectionId", "type", "bytes32"));
        ArrayList<Map<String, String>> eipTypes = new ArrayList<Map<String, String>>();
        eipTypes.add(Map.of("name", "name", "type", "string"));
        eipTypes.add(Map.of("name", "version", "type", "string"));
        eipTypes.add(Map.of("name", "chainId", "type", "uint256"));
        eipTypes.add(Map.of("name", "verifyingContract", "type", "address"));
        LinkedHashMap<String, ArrayList<Map<String, String>>> types = new LinkedHashMap<String, ArrayList<Map<String, String>>>();
        types.put("Agent", agentTypes);
        types.put("EIP712Domain", eipTypes);
        LinkedHashMap<String, Object> full = new LinkedHashMap<String, Object>();
        full.put("domain", domain);
        full.put("types", types);
        full.put("primaryType", "Agent");
        full.put("message", phantomAgent);
        try {
            return JSONUtil.writeValueAsString(full);
        }
        catch (JsonProcessingException e) {
            throw new HypeError("Failed to build typed data json: " + e.getMessage());
        }
    }

    public static Map<String, Object> signL1Action(Credentials credentials, Object action, String vaultAddress, long nonce, Long expiresAfter, boolean isMainnet) {
        byte[] hash = Signing.actionHash(action, nonce, vaultAddress, expiresAfter);
        Map<String, Object> agent = Signing.constructPhantomAgent(hash, isMainnet);
        String typedJson = Signing.l1PayloadJson(agent);
        return Signing.signTypedData(credentials, typedJson);
    }

    public static String userSignedPayloadJson(String primaryType, List<Map<String, Object>> payloadTypes, Map<String, Object> action) {
        int chainId;
        Object sigChainIdObj = action.get("signatureChainId");
        if (sigChainIdObj == null) {
            throw new HypeError("signatureChainId missing in user-signed action");
        }
        String sigChainIdHex = String.valueOf(sigChainIdObj);
        try {
            chainId = new BigInteger(sigChainIdHex.replace("0x", ""), 16).intValue();
        }
        catch (Exception e) {
            throw new HypeError("Invalid signatureChainId: " + sigChainIdHex);
        }
        LinkedHashMap<String, Object> domain = new LinkedHashMap<String, Object>();
        domain.put("name", "HyperliquidSignTransaction");
        domain.put("version", "1");
        domain.put("chainId", chainId);
        domain.put("verifyingContract", "0x0000000000000000000000000000000000000000");
        ArrayList<Map<String, String>> eipTypes = new ArrayList<Map<String, String>>();
        eipTypes.add(Map.of("name", "name", "type", "string"));
        eipTypes.add(Map.of("name", "version", "type", "string"));
        eipTypes.add(Map.of("name", "chainId", "type", "uint256"));
        eipTypes.add(Map.of("name", "verifyingContract", "type", "address"));
        LinkedHashMap<String, List<Map<String, Object>>> types = new LinkedHashMap<String, List<Map<String, Object>>>();
        types.put(primaryType, payloadTypes);
        types.put("EIP712Domain", eipTypes);
        LinkedHashMap<String, Object> full = new LinkedHashMap<String, Object>();
        full.put("domain", domain);
        full.put("types", types);
        full.put("primaryType", primaryType);
        full.put("message", action);
        try {
            return JSONUtil.writeValueAsString(full);
        }
        catch (JsonProcessingException e) {
            throw new HypeError("Failed to build user-signed typed data json: " + e.getMessage());
        }
    }

    public static Map<String, Object> signUserSignedAction(Credentials credentials, Map<String, Object> action, List<Map<String, Object>> payloadTypes, String primaryType, boolean isMainnet) {
        action.put("signatureChainId", "0x66eee");
        action.put("hyperliquidChain", isMainnet ? "Mainnet" : "Testnet");
        String typedJson = Signing.userSignedPayloadJson(primaryType, payloadTypes, action);
        return Signing.signTypedData(credentials, typedJson);
    }

    public static String recoverFromTypedData(String typedDataJson, Map<String, Object> signature) {
        try {
            int recId;
            StructuredDataEncoder encoder = new StructuredDataEncoder(typedDataJson);
            byte[] digest = encoder.hashStructuredData();
            String rHex = String.valueOf(signature.get("r"));
            String sHex = String.valueOf(signature.get("s"));
            int vInt = Integer.parseInt(String.valueOf(signature.get("v")));
            byte[] r = Numeric.hexStringToByteArray((String)rHex);
            byte[] s = Numeric.hexStringToByteArray((String)sHex);
            byte vByte = (byte)vInt;
            if (vInt == 27 || vInt == 28) {
                recId = vInt - 27;
            } else if (vInt == 0 || vInt == 1) {
                recId = vInt;
            } else if (vInt >= 35) {
                recId = (vInt - 35) % 2;
            } else {
                throw new HypeError("Unsupported v value for recovery: " + vInt);
            }
            BigInteger rBI = new BigInteger(1, r);
            BigInteger sBI = new BigInteger(1, s);
            BigInteger pubKey = Signing.recoverPublicKeyFromSignature(recId, rBI, sBI, digest);
            String addr = Keys.getAddress((BigInteger)pubKey);
            return "0x" + addr.toLowerCase();
        }
        catch (Exception e) {
            throw new HypeError("Failed to recover address: " + e.getMessage());
        }
    }

    public static String recoverAddressFromDigest(byte[] digest, Map<String, Object> signature) {
        int recId;
        String rHex = String.valueOf(signature.get("r"));
        String sHex = String.valueOf(signature.get("s"));
        int vInt = Integer.parseInt(String.valueOf(signature.get("v")));
        byte[] r = Numeric.hexStringToByteArray((String)rHex);
        byte[] s = Numeric.hexStringToByteArray((String)sHex);
        if (vInt == 27 || vInt == 28) {
            recId = vInt - 27;
        } else if (vInt == 0 || vInt == 1) {
            recId = vInt;
        } else if (vInt >= 35) {
            recId = (vInt - 35) % 2;
        } else {
            throw new HypeError("Unsupported v value for recovery: " + vInt);
        }
        BigInteger rBI = new BigInteger(1, r);
        BigInteger sBI = new BigInteger(1, s);
        BigInteger pubKey = Signing.recoverPublicKeyFromSignature(recId, rBI, sBI, digest);
        String addr = Keys.getAddress((BigInteger)pubKey);
        return "0x" + addr.toLowerCase();
    }

    private static BigInteger recoverPublicKeyFromSignature(int recId, BigInteger r, BigInteger s, byte[] digest) {
        boolean yBit;
        X9ECParameters x9 = CustomNamedCurves.getByName((String)"secp256k1");
        ECDomainParameters curve = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH());
        BigInteger n = curve.getN();
        BigInteger i = BigInteger.valueOf(recId / 2);
        BigInteger x = r.add(i.multiply(n));
        ECPoint R = Signing.decompressKey(x, yBit = recId % 2 == 1, curve.getCurve());
        if (R == null || !R.multiply(n).isInfinity()) {
            throw new HypeError("Invalid R point during public key recovery");
        }
        BigInteger e = new BigInteger(1, digest);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = s.multiply(rInv).mod(n);
        BigInteger eInv = e.negate().mod(n);
        BigInteger eInvRInv = eInv.multiply(rInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)curve.getG(), (BigInteger)eInvRInv, (ECPoint)R, (BigInteger)srInv);
        byte[] pubKeyEncoded = q.getEncoded(false);
        byte[] pubKeyNoPrefix = Arrays.copyOfRange(pubKeyEncoded, 1, pubKeyEncoded.length);
        return new BigInteger(1, pubKeyNoPrefix);
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit, ECCurve curve) {
        byte[] compEnc = new byte[33];
        compEnc[0] = (byte)(yBit ? 3 : 2);
        byte[] xBytes = xBN.toByteArray();
        int start = Math.max(0, xBytes.length - 32);
        int length = Math.min(32, xBytes.length);
        System.arraycopy(xBytes, start, compEnc, 33 - length, length);
        return curve.decodePoint(compEnc);
    }

    public static String recoverAgentOrUserFromL1Action(Object action, String vaultAddress, long nonce, Long expiresAfter, boolean isMainnet, Map<String, Object> signature) {
        byte[] hash = Signing.actionHash(action, nonce, vaultAddress, expiresAfter);
        Map<String, Object> agent = Signing.constructPhantomAgent(hash, isMainnet);
        String typedJson = Signing.l1PayloadJson(agent);
        return Signing.recoverFromTypedData(typedJson, signature);
    }

    public static String recoverUserFromUserSignedAction(Map<String, Object> action, Map<String, Object> signature, List<Map<String, Object>> payloadTypes, String primaryType, boolean isMainnet) {
        action.put("hyperliquidChain", isMainnet ? "Mainnet" : "Testnet");
        String typedJson = Signing.userSignedPayloadJson(primaryType, payloadTypes, action);
        return Signing.recoverFromTypedData(typedJson, signature);
    }

    public static Map<String, Object> orderWiresToOrderAction(List<OrderWire> orders) {
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>();
        action.put("type", "order");
        ArrayList wires = new ArrayList();
        for (OrderWire o : orders) {
            LinkedHashMap<String, Object> w = new LinkedHashMap<String, Object>();
            w.put("a", o.coin);
            w.put("b", o.isBuy);
            if (o.limitPx != null) {
                w.put("p", o.limitPx);
            }
            w.put("s", o.sz);
            w.put("r", o.reduceOnly);
            if (o.orderType != null) {
                w.put("t", o.orderType);
            }
            if (o.cloid != null) {
                w.put("c", o.cloid.getRaw());
            }
            wires.add(w);
        }
        action.put("orders", wires);
        action.put("grouping", "na");
        return action;
    }

    public static void setStrictAddressLength(boolean strict) {
        STRICT_ADDRESS_LENGTH = strict;
    }

    public static boolean isStrictAddressLength() {
        return STRICT_ADDRESS_LENGTH;
    }

    public static Map<String, Object> signMultiSigAction(Credentials wallet, Map<String, Object> multiSigAction, boolean isMainnet, String vaultAddress, long nonce, Long expiresAfter) {
        Map payload = (Map)multiSigAction.get("payload");
        if (payload == null) {
            throw new IllegalArgumentException("multiSigAction must contain 'payload'");
        }
        Map innerAction = (Map)payload.get("action");
        if (innerAction == null) {
            throw new IllegalArgumentException("payload must contain 'action'");
        }
        byte[] innerActionHash = Signing.actionHash(innerAction, nonce, vaultAddress, expiresAfter);
        LinkedHashMap<String, CallSite> enrichedPayload = new LinkedHashMap<String, CallSite>(payload);
        enrichedPayload.put("multiSigActionHash", (CallSite)((Object)("0x" + Numeric.toHexStringNoPrefix((byte[])innerActionHash))));
        String chainId = isMainnet ? "0x66eee" : "0x66eef";
        LinkedHashMap<String, String> domain = new LinkedHashMap<String, String>();
        domain.put("name", "Exchange");
        domain.put("version", "1");
        domain.put("chainId", chainId);
        domain.put("verifyingContract", "0x0000000000000000000000000000000000000000");
        LinkedHashMap<String, String> multiSigType = new LinkedHashMap<String, String>();
        multiSigType.put("name", "multiSigUser");
        multiSigType.put("type", "address");
        LinkedHashMap<String, String> outerSignerType = new LinkedHashMap<String, String>();
        outerSignerType.put("name", "outerSigner");
        outerSignerType.put("type", "address");
        LinkedHashMap<String, String> actionType = new LinkedHashMap<String, String>();
        actionType.put("name", "action");
        actionType.put("type", "string");
        LinkedHashMap<String, String> multiSigHashType = new LinkedHashMap<String, String>();
        multiSigHashType.put("name", "multiSigActionHash");
        multiSigHashType.put("type", "bytes32");
        LinkedHashMap<String, List<Map>> types = new LinkedHashMap<String, List<Map>>();
        types.put("EIP712Domain", Arrays.asList(Map.of("name", "name", "type", "string"), Map.of("name", "version", "type", "string"), Map.of("name", "chainId", "type", "string"), Map.of("name", "verifyingContract", "type", "address")));
        types.put("HyperliquidTransaction:MultiSig", Arrays.asList(multiSigType, outerSignerType, actionType, multiSigHashType));
        LinkedHashMap<String, Object> typedData = new LinkedHashMap<String, Object>();
        typedData.put("domain", domain);
        typedData.put("types", types);
        typedData.put("primaryType", "HyperliquidTransaction:MultiSig");
        typedData.put("message", enrichedPayload);
        try {
            String typedDataJson = JSONUtil.writeValueAsString(typedData);
            return Signing.signTypedData(wallet, typedDataJson);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to sign multi-sig action", e);
        }
    }
}

