/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.apis;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import io.github.hyperliquid.sdk.config.CacheConfig;
import io.github.hyperliquid.sdk.model.info.Candle;
import io.github.hyperliquid.sdk.model.info.CandleInterval;
import io.github.hyperliquid.sdk.model.info.ClearinghouseState;
import io.github.hyperliquid.sdk.model.info.FrontendOpenOrder;
import io.github.hyperliquid.sdk.model.info.FundingHistory;
import io.github.hyperliquid.sdk.model.info.L2Book;
import io.github.hyperliquid.sdk.model.info.Meta;
import io.github.hyperliquid.sdk.model.info.MetaAndAssetCtxs;
import io.github.hyperliquid.sdk.model.info.OpenOrder;
import io.github.hyperliquid.sdk.model.info.OrderStatus;
import io.github.hyperliquid.sdk.model.info.PerpDexStatus;
import io.github.hyperliquid.sdk.model.info.SpotClearinghouseState;
import io.github.hyperliquid.sdk.model.info.SpotMeta;
import io.github.hyperliquid.sdk.model.info.UserFill;
import io.github.hyperliquid.sdk.model.info.UserRateLimit;
import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.subscription.Subscription;
import io.github.hyperliquid.sdk.utils.HypeError;
import io.github.hyperliquid.sdk.utils.HypeHttpClient;
import io.github.hyperliquid.sdk.utils.JSONUtil;
import io.github.hyperliquid.sdk.websocket.WebsocketManager;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class Info {
    private final boolean skipWs;
    private WebsocketManager wsManager;
    private final HypeHttpClient hypeHttpClient;
    private final Cache<String, Meta> metaCache;
    private final Cache<String, SpotMeta> spotMetaCache;
    private final Map<String, Integer> coinToAssetCache = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, Integer> assetToSzDecimalsCache = new ConcurrentHashMap<Integer, Integer>();

    public Info(String baseUrl, HypeHttpClient hypeHttpClient, boolean skipWs) {
        this(baseUrl, hypeHttpClient, skipWs, CacheConfig.defaultConfig());
    }

    public Info(String baseUrl, HypeHttpClient hypeHttpClient, boolean skipWs, CacheConfig cacheConfig) {
        this.hypeHttpClient = hypeHttpClient;
        this.skipWs = skipWs;
        if (!skipWs) {
            this.wsManager = new WebsocketManager(baseUrl);
        }
        Caffeine metaCacheBuilder = Caffeine.newBuilder().maximumSize((long)cacheConfig.getMetaCacheMaxSize()).expireAfterWrite(cacheConfig.getExpireAfterWriteMinutes(), TimeUnit.MINUTES);
        if (cacheConfig.isRecordStats()) {
            metaCacheBuilder.recordStats();
        }
        this.metaCache = metaCacheBuilder.build();
        Caffeine spotMetaCacheBuilder = Caffeine.newBuilder().maximumSize((long)cacheConfig.getSpotMetaCacheMaxSize()).expireAfterWrite(cacheConfig.getExpireAfterWriteMinutes(), TimeUnit.MINUTES);
        if (cacheConfig.isRecordStats()) {
            spotMetaCacheBuilder.recordStats();
        }
        this.spotMetaCache = spotMetaCacheBuilder.build();
    }

    public Integer nameToAsset(String coinName) {
        String normalizedName = coinName.trim().toUpperCase();
        Integer assetId = this.coinToAssetCache.get(normalizedName);
        if (assetId != null) {
            return assetId;
        }
        Meta meta = this.loadMetaCache();
        this.buildCoinMappingCache(meta);
        assetId = this.coinToAssetCache.get(normalizedName);
        if (assetId == null) {
            throw new HypeError("Unknown currency name:" + normalizedName);
        }
        return assetId;
    }

    public JsonNode postInfo(Object payload) {
        return this.hypeHttpClient.post("/info", payload);
    }

    public Map<String, String> allMids(String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "allMids");
        if (dex != null) {
            payload.put("dex", dex);
        }
        JsonNode node = this.postInfo(payload);
        return (Map)JSONUtil.convertValue(node, TypeFactory.defaultInstance().constructMapType(Map.class, String.class, String.class));
    }

    public Map<String, String> allMids() {
        return this.allMids(null);
    }

    public Meta meta() {
        return this.meta(null);
    }

    public Meta loadMetaCache() {
        return this.loadMetaCache(null);
    }

    public Meta loadMetaCache(String dex) {
        String cacheKey = this.buildMetaCacheKey(dex);
        return (Meta)this.metaCache.get((Object)cacheKey, key -> {
            Meta meta = this.meta(dex);
            this.buildCoinMappingCache(meta);
            return meta;
        });
    }

    public Meta refreshMetaCache(String dex) {
        String cacheKey = this.buildMetaCacheKey(dex);
        this.metaCache.invalidate((Object)cacheKey);
        this.coinToAssetCache.clear();
        this.assetToSzDecimalsCache.clear();
        return this.loadMetaCache(dex);
    }

    public Meta refreshMetaCache() {
        return this.refreshMetaCache(null);
    }

    public void clearMetaCache() {
        this.metaCache.invalidateAll();
        this.coinToAssetCache.clear();
        this.assetToSzDecimalsCache.clear();
    }

    public CacheStats getMetaCacheStats() {
        return this.metaCache.stats();
    }

    private String buildMetaCacheKey(String dex) {
        return dex == null || dex.isEmpty() ? "meta:default" : "meta:" + dex;
    }

    private void buildCoinMappingCache(Meta meta) {
        if (meta == null || meta.getUniverse() == null) {
            return;
        }
        List<Meta.Universe> universe = meta.getUniverse();
        for (int assetId = 0; assetId < universe.size(); ++assetId) {
            Meta.Universe u = universe.get(assetId);
            if (u.getName() == null) continue;
            String coinName = u.getName().toUpperCase();
            this.coinToAssetCache.put(coinName, assetId);
            if (u.getSzDecimals() == null) continue;
            this.assetToSzDecimalsCache.put(assetId, u.getSzDecimals());
        }
    }

    public Meta.Universe getMetaUniverse(String coinName) {
        Integer assetId = this.nameToAsset(coinName);
        List<Meta.Universe> universe = this.loadMetaCache().getUniverse();
        if (assetId >= 0 && assetId < universe.size()) {
            return universe.get(assetId);
        }
        throw new HypeError("Unknown currency name:" + coinName);
    }

    public Integer getSzDecimals(String coinName) {
        Integer assetId = this.nameToAsset(coinName);
        Integer szDecimals = this.assetToSzDecimalsCache.get(assetId);
        if (szDecimals != null) {
            return szDecimals;
        }
        Meta.Universe universe = this.getMetaUniverse(coinName);
        szDecimals = universe.getSzDecimals();
        if (szDecimals == null) {
            throw new HypeError("szDecimals not defined for coin: " + coinName);
        }
        this.assetToSzDecimalsCache.put(assetId, szDecimals);
        return szDecimals;
    }

    public Meta meta(String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "meta");
        if (dex != null) {
            payload.put("dex", dex);
        }
        return JSONUtil.convertValue((Object)this.postInfo(payload), Meta.class);
    }

    public JsonNode metaAndAssetCtxs() {
        Map<String, String> payload = Map.of("type", "metaAndAssetCtxs");
        return this.postInfo(payload);
    }

    public MetaAndAssetCtxs metaAndAssetCtxsTyped() {
        JsonNode node = this.metaAndAssetCtxs();
        return JSONUtil.convertValue((Object)node, MetaAndAssetCtxs.class);
    }

    public SpotMeta spotMeta() {
        Map<String, String> payload = Map.of("type", "spotMeta");
        return JSONUtil.convertValue((Object)this.postInfo(payload), SpotMeta.class);
    }

    public SpotMeta loadSpotMetaCache() {
        return (SpotMeta)this.spotMetaCache.get((Object)"spotMeta", key -> this.spotMeta());
    }

    public SpotMeta refreshSpotMetaCache() {
        this.spotMetaCache.invalidate((Object)"spotMeta");
        return this.loadSpotMetaCache();
    }

    public void clearSpotMetaCache() {
        this.spotMetaCache.invalidateAll();
    }

    public CacheStats getSpotMetaCacheStats() {
        return this.spotMetaCache.stats();
    }

    public void warmUpCache() {
        this.loadMetaCache();
        this.loadSpotMetaCache();
    }

    public void warmUpCache(List<String> dexList) {
        if (dexList == null || dexList.isEmpty()) {
            this.warmUpCache();
            return;
        }
        for (String dex : dexList) {
            this.loadMetaCache(dex);
        }
        this.loadSpotMetaCache();
    }

    public JsonNode spotMetaAndAssetCtxs() {
        Map<String, String> payload = Map.of("type", "spotMetaAndAssetCtxs");
        return this.postInfo(payload);
    }

    public L2Book l2Book(String coin, Integer nSigFigs, Integer mantissa) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "l2Book");
        payload.put("coin", coin);
        if (nSigFigs != null) {
            payload.put("nSigFigs", nSigFigs);
        }
        if (mantissa != null) {
            payload.put("mantissa", mantissa);
        }
        return JSONUtil.convertValue((Object)this.postInfo(payload), L2Book.class);
    }

    public L2Book l2Book(String coin) {
        return this.l2Book(coin, null, null);
    }

    public List<Candle> candleSnapshot(String coin, CandleInterval interval, Long startTime, Long endTime) {
        if (coin == null || coin.trim().isEmpty()) {
            throw new HypeError("Coin name cannot be null or empty");
        }
        if (interval == null) {
            throw new HypeError("Interval cannot be null");
        }
        if (startTime == null || startTime < 0L) {
            throw new HypeError("Invalid start time: " + startTime);
        }
        if (endTime == null || endTime < 0L) {
            throw new HypeError("Invalid end time: " + endTime);
        }
        if (endTime < startTime) {
            throw new HypeError("End time cannot be earlier than start time");
        }
        LinkedHashMap<String, Object> req = new LinkedHashMap<String, Object>();
        req.put("coin", coin);
        req.put("interval", interval.getCode());
        req.put("startTime", startTime);
        req.put("endTime", endTime);
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "candleSnapshot");
        payload.put("req", req);
        return JSONUtil.toList(this.postInfo(payload), Candle.class);
    }

    public Candle candleSnapshotLatest(String coin, CandleInterval interval) {
        long endTime = System.currentTimeMillis();
        long startTime = endTime - interval.toMillis() * 2L;
        List<Candle> candles = this.candleSnapshot(coin, interval, startTime, endTime);
        return !candles.isEmpty() ? candles.getLast() : null;
    }

    public List<Candle> candleSnapshotByCount(String coin, CandleInterval interval, int count) {
        if (count <= 0) {
            throw new HypeError("count must be greater than 0");
        }
        if (count > 5000) {
            throw new HypeError("count cannot exceed 5000 (API limit)");
        }
        long endTime = System.currentTimeMillis();
        long startTime = endTime - interval.toMillis() * (long)(count + 2);
        List<Candle> candles = this.candleSnapshot(coin, interval, startTime, endTime);
        if (candles.size() > count) {
            return candles.subList(candles.size() - count, candles.size());
        }
        return candles;
    }

    public List<Candle> candleSnapshotByDays(String coin, CandleInterval interval, int days) {
        if (days <= 0) {
            throw new HypeError("days must be greater than 0");
        }
        long endTime = System.currentTimeMillis();
        long startTime = endTime - (long)(days * 24 * 60 * 60) * 1000L;
        return this.candleSnapshot(coin, interval, startTime, endTime);
    }

    public List<Candle> candleSnapshotByDate(String coin, CandleInterval interval, int year, int month, int day) {
        if (year < 2000 || year > 2100) {
            throw new HypeError("Invalid year: " + year);
        }
        if (month < 1 || month > 12) {
            throw new HypeError("Invalid month: " + month);
        }
        if (day < 1 || day > 31) {
            throw new HypeError("Invalid day: " + day);
        }
        long startTime = LocalDate.of(year, month, day).atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli();
        long endTime = LocalDate.of(year, month, day).atTime(23, 59, 59, 999999999).toInstant(ZoneOffset.UTC).toEpochMilli();
        return this.candleSnapshot(coin, interval, startTime, endTime);
    }

    public Candle candleSnapshotCurrent(String coin, CandleInterval interval) {
        long endTime = System.currentTimeMillis();
        long startTime = endTime - interval.toMillis() * 2L;
        List<Candle> candles = this.candleSnapshot(coin, interval, startTime, endTime);
        return !candles.isEmpty() ? candles.getLast() : null;
    }

    public List<OpenOrder> openOrders(String address) {
        return this.openOrders(address, null);
    }

    public List<OpenOrder> openOrders(String address, String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "openOrders");
        payload.put("user", address);
        if (dex != null) {
            payload.put("dex", dex);
        }
        return JSONUtil.toList(this.postInfo(payload), OpenOrder.class);
    }

    public List<UserFill> userFillsByTime(String address, Long startTime, Long endTime, Boolean aggregateByTime) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFillsByTime");
        payload.put("user", address);
        payload.put("startTime", startTime);
        if (endTime != null) {
            payload.put("endTime", endTime);
        }
        if (aggregateByTime != null) {
            payload.put("aggregateByTime", aggregateByTime);
        }
        return JSONUtil.toList(this.postInfo(payload), UserFill.class);
    }

    public List<UserFill> userFillsByTime(String address, Long startTime) {
        return this.userFillsByTime(address, startTime, null, null);
    }

    public List<UserFill> userFillsByTime(String address, Long startTime, Long endTime) {
        return this.userFillsByTime(address, startTime, endTime, null);
    }

    public List<UserFill> userFillsByTime(String address, Long startTime, Boolean aggregateByTime) {
        return this.userFillsByTime(address, startTime, null, aggregateByTime);
    }

    public JsonNode userFees(String address) {
        Map<String, String> payload = Map.of("type", "userFees", "user", address);
        return this.postInfo(payload);
    }

    public List<FundingHistory> fundingHistory(String coin, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "fundingHistory");
        payload.put("coin", coin);
        payload.put("startTime", startMs);
        payload.put("endTime", endMs);
        return JSONUtil.toList(this.postInfo(payload), FundingHistory.class);
    }

    public JsonNode userFundingHistory(String address, int coin, long startMs, long endMs) {
        return this.userFundingHistory(address, this.coinIdToInfoCoinString(coin), startMs, endMs);
    }

    private String coinIdToInfoCoinString(int coinId) {
        Meta meta = this.loadMetaCache();
        List<Meta.Universe> universe = meta.getUniverse();
        if (coinId < 0 || coinId >= universe.size()) {
            throw new HypeError("Unknown asset id:" + coinId);
        }
        return "@" + coinId;
    }

    public JsonNode userFundingHistory(String address, String coin, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFunding");
        payload.put("user", address);
        payload.put("startTime", startMs);
        payload.put("endTime", endMs);
        return this.postInfo(payload);
    }

    public JsonNode userFundingHistory(String address, long startMs, Long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFunding");
        payload.put("user", address);
        payload.put("startTime", startMs);
        if (endMs != null) {
            payload.put("endTime", endMs);
        }
        return this.postInfo(payload);
    }

    public JsonNode userNonFundingLedgerUpdates(String address, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userNonFundingLedgerUpdates");
        payload.put("user", address);
        payload.put("startTime", startMs);
        payload.put("endTime", endMs);
        return this.postInfo(payload);
    }

    public JsonNode historicalOrders(String address, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "historicalOrders");
        payload.put("user", address);
        payload.put("startTime", startMs);
        payload.put("endTime", endMs);
        return this.postInfo(payload);
    }

    public JsonNode userTwapSliceFills(String address, long startMs, long endMs) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userTwapSliceFills");
        payload.put("user", address);
        payload.put("startTime", startMs);
        payload.put("endTime", endMs);
        return this.postInfo(payload);
    }

    public List<FrontendOpenOrder> frontendOpenOrders(String address, String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "frontendOpenOrders");
        payload.put("user", address);
        if (dex != null) {
            payload.put("dex", dex);
        }
        return JSONUtil.toList(this.postInfo(payload), FrontendOpenOrder.class);
    }

    public List<FrontendOpenOrder> frontendOpenOrders(String address) {
        return this.frontendOpenOrders(address, null);
    }

    public List<UserFill> userFills(String address, Boolean aggregateByTime) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("type", "userFills");
        payload.put("user", address);
        if (aggregateByTime != null) {
            payload.put("aggregateByTime", aggregateByTime);
        }
        return JSONUtil.toList(this.postInfo(payload), UserFill.class);
    }

    public List<UserFill> userFills(String address) {
        return this.userFills(address, null);
    }

    public JsonNode perpDexs() {
        Map<String, String> payload = Map.of("type", "perpDexs");
        return this.postInfo(payload);
    }

    public List<Map<String, Object>> perpDexsTyped() {
        JsonNode node = this.perpDexs();
        return (List)JSONUtil.convertValue((Object)node, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class)));
    }

    public ClearinghouseState clearinghouseState(String address, String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "clearinghouseState");
        payload.put("user", address);
        if (dex != null && !dex.isEmpty()) {
            payload.put("dex", dex);
        }
        return JSONUtil.convertValue((Object)this.postInfo(payload), ClearinghouseState.class);
    }

    public ClearinghouseState clearinghouseState(String address) {
        return this.clearinghouseState(address, null);
    }

    public ClearinghouseState userState(String address) {
        return this.clearinghouseState(address, null);
    }

    public SpotClearinghouseState spotClearinghouseState(String address) {
        Map<String, String> payload = Map.of("type", "spotClearinghouseState", "user", address);
        JsonNode node = this.postInfo(payload);
        return JSONUtil.convertValue((Object)node, SpotClearinghouseState.class);
    }

    public JsonNode vaultDetails(String vaultAddress, String user) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "vaultDetails");
        payload.put("vaultAddress", vaultAddress);
        if (user != null) {
            payload.put("user", user);
        }
        return this.postInfo(payload);
    }

    public JsonNode spotDeployState(String address) {
        Map<String, String> payload = Map.of("type", "spotDeployState", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode portfolio(String address) {
        Map<String, String> payload = Map.of("type", "portfolio", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode userRole(String address) {
        Map<String, String> payload = Map.of("type", "userRole", "user", address);
        return this.postInfo(payload);
    }

    public UserRateLimit userRateLimit(String address) {
        Map<String, String> payload = Map.of("type", "userRateLimit", "user", address);
        return JSONUtil.convertValue((Object)this.postInfo(payload), UserRateLimit.class);
    }

    public OrderStatus orderStatus(String address, Long oid) {
        Map<String, Long> payload = Map.of("type", "orderStatus", "user", address, "oid", oid);
        return JSONUtil.convertValue((Object)this.postInfo(payload), OrderStatus.class);
    }

    public OrderStatus orderStatusByCloid(String address, Cloid cloid) {
        if (cloid == null) {
            throw new HypeError("cloid cannot be null");
        }
        Map<String, String> payload = Map.of("type", "orderStatus", "user", address, "oid", cloid.getRaw());
        return JSONUtil.convertValue((Object)this.postInfo(payload), OrderStatus.class);
    }

    public JsonNode queryReferralState(String address) {
        Map<String, String> payload = Map.of("type", "referral", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode querySubAccounts(String address) {
        Map<String, String> payload = Map.of("type", "subAccounts", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode queryUserToMultiSigSigners(String address) {
        Map<String, String> payload = Map.of("type", "userToMultiSigSigners", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode queryPerpDeployAuctionStatus() {
        Map<String, String> payload = Map.of("type", "perpDeployAuctionStatus");
        return this.postInfo(payload);
    }

    public JsonNode querySpotDeployAuctionStatus() {
        try {
            return JSONUtil.readTree("{}");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse empty JSON", e);
        }
    }

    public JsonNode perpDexStatus(String dex) {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", "perpDexStatus");
        payload.put("dex", dex == null ? "" : dex);
        return this.postInfo(payload);
    }

    public PerpDexStatus perpDexStatusTyped(String dex) {
        JsonNode node = this.perpDexStatus(dex);
        return JSONUtil.convertValue((Object)node, PerpDexStatus.class);
    }

    public JsonNode queryUserDexAbstractionState(String address) {
        Map<String, String> payload = Map.of("type", "userDexAbstraction", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode userVaultEquities(String address) {
        Map<String, String> payload = Map.of("type", "userVaultEquities", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode extraAgents(String address) {
        Map<String, String> payload = Map.of("type", "extraAgents", "user", address);
        return this.postInfo(payload);
    }

    public void subscribe(Subscription subscription, WebsocketManager.MessageCallback callback) {
        if (this.skipWs) {
            throw new HypeError("WebSocket disabled by skipWs");
        }
        this.wsManager.subscribe(subscription, callback);
    }

    public void subscribe(JsonNode subscription, WebsocketManager.MessageCallback callback) {
        if (this.skipWs) {
            throw new HypeError("WebSocket disabled by skipWs");
        }
        this.wsManager.subscribe(subscription, callback);
    }

    public Map<String, List<WebsocketManager.ActiveSubscription>> getSubscriptions() {
        if (this.skipWs) {
            throw new HypeError("WebSocket disabled by skipWs");
        }
        return this.wsManager.getSubscriptions();
    }

    public void unsubscribe(Subscription subscription) {
        if (this.skipWs) {
            return;
        }
        this.wsManager.unsubscribe(subscription);
    }

    public void unsubscribe(JsonNode subscription) {
        if (this.skipWs) {
            return;
        }
        this.wsManager.unsubscribe(subscription);
    }

    public void closeWs() {
        if (this.wsManager != null) {
            this.wsManager.stop();
        }
    }

    public void addConnectionListener(WebsocketManager.ConnectionListener listener) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.addConnectionListener(listener);
        }
    }

    public void removeConnectionListener(WebsocketManager.ConnectionListener listener) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.removeConnectionListener(listener);
        }
    }

    public void setNetworkCheckIntervalSeconds(int seconds) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setNetworkCheckIntervalSeconds(seconds);
        }
    }

    public void setReconnectBackoffMs(long initialMs, long maxMs) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setReconnectBackoffMs(initialMs, maxMs);
        }
    }

    public void setNetworkProbeUrl(String url) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setNetworkProbeUrl(url);
        }
    }

    public void setNetworkProbeDisabled(boolean disabled) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.setNetworkProbeDisabled(disabled);
        }
    }

    public void addCallbackErrorListener(WebsocketManager.CallbackErrorListener listener) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.addCallbackErrorListener(listener);
        }
    }

    public void removeCallbackErrorListener(WebsocketManager.CallbackErrorListener listener) {
        if (this.skipWs) {
            return;
        }
        if (this.wsManager != null) {
            this.wsManager.removeCallbackErrorListener(listener);
        }
    }

    public WebsocketManager getWsManager() {
        return this.wsManager;
    }

    public JsonNode userStakingSummary(String address) {
        Map<String, String> payload = Map.of("type", "delegatorSummary", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode userStakingDelegations(String address) {
        Map<String, String> payload = Map.of("type", "delegations", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode userStakingRewards(String address) {
        Map<String, String> payload = Map.of("type", "delegatorRewards", "user", address);
        return this.postInfo(payload);
    }

    public JsonNode delegatorHistory(String user) {
        Map<String, String> payload = Map.of("type", "delegatorHistory", "user", user);
        return this.postInfo(payload);
    }
}

