/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

public class TriggerOrderType {
    private final String triggerPx;
    private final Boolean isMarket;
    private final TpslType tpsl;

    public TriggerOrderType(String triggerPx, boolean isMarket, TpslType tpsl) {
        if (tpsl == null) {
            throw new IllegalArgumentException("tpsl cannot be null (must specify trigger direction: TP=break above, SL=break below)");
        }
        this.triggerPx = triggerPx;
        this.isMarket = isMarket;
        this.tpsl = tpsl;
    }

    public String getTriggerPx() {
        return this.triggerPx;
    }

    public boolean isMarket() {
        return this.isMarket;
    }

    public String getTpsl() {
        return this.tpsl.getValue();
    }

    public TpslType getTpslEnum() {
        return this.tpsl;
    }

    public static enum TpslType {
        TP("tp"),
        SL("sl");

        private final String value;

        private TpslType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

