/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.config;

public class CacheConfig {
    private int metaCacheMaxSize = 20;
    private int spotMetaCacheMaxSize = 10;
    private long expireAfterWriteMinutes = 30L;
    private boolean recordStats = true;

    public CacheConfig() {
    }

    public CacheConfig(int metaCacheMaxSize, int spotMetaCacheMaxSize, long expireAfterWriteMinutes, boolean recordStats) {
        this.metaCacheMaxSize = metaCacheMaxSize;
        this.spotMetaCacheMaxSize = spotMetaCacheMaxSize;
        this.expireAfterWriteMinutes = expireAfterWriteMinutes;
        this.recordStats = recordStats;
    }

    public static CacheConfig defaultConfig() {
        return new CacheConfig();
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMetaCacheMaxSize() {
        return this.metaCacheMaxSize;
    }

    public void setMetaCacheMaxSize(int metaCacheMaxSize) {
        this.metaCacheMaxSize = metaCacheMaxSize;
    }

    public int getSpotMetaCacheMaxSize() {
        return this.spotMetaCacheMaxSize;
    }

    public void setSpotMetaCacheMaxSize(int spotMetaCacheMaxSize) {
        this.spotMetaCacheMaxSize = spotMetaCacheMaxSize;
    }

    public long getExpireAfterWriteMinutes() {
        return this.expireAfterWriteMinutes;
    }

    public void setExpireAfterWriteMinutes(long expireAfterWriteMinutes) {
        this.expireAfterWriteMinutes = expireAfterWriteMinutes;
    }

    public boolean isRecordStats() {
        return this.recordStats;
    }

    public void setRecordStats(boolean recordStats) {
        this.recordStats = recordStats;
    }

    public static class Builder {
        private int metaCacheMaxSize = 20;
        private int spotMetaCacheMaxSize = 10;
        private long expireAfterWriteMinutes = 30L;
        private boolean recordStats = true;

        public Builder metaCacheMaxSize(int maxSize) {
            this.metaCacheMaxSize = maxSize;
            return this;
        }

        public Builder spotMetaCacheMaxSize(int maxSize) {
            this.spotMetaCacheMaxSize = maxSize;
            return this;
        }

        public Builder expireAfterWriteMinutes(long minutes) {
            this.expireAfterWriteMinutes = minutes;
            return this;
        }

        public Builder recordStats(boolean recordStats) {
            this.recordStats = recordStats;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.metaCacheMaxSize, this.spotMetaCacheMaxSize, this.expireAfterWriteMinutes, this.recordStats);
        }
    }
}

