/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ApiError {
    private final String code;
    private final String message;
    private final Integer statusCode;
    private final Map<String, Object> context;

    public ApiError(String code, String message) {
        this(code, message, null, Collections.emptyMap());
    }

    public ApiError(String code, String message, Integer statusCode) {
        this(code, message, statusCode, Collections.emptyMap());
    }

    public ApiError(String code, String message, Integer statusCode, Map<String, Object> context) {
        this.code = code;
        this.message = message;
        this.statusCode = statusCode;
        this.context = context == null ? Collections.emptyMap() : new LinkedHashMap<String, Object>(context);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public Map<String, Object> getContext() {
        return Collections.unmodifiableMap(this.context);
    }
}

