/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

public final class RetryPolicy {
    private final int maxRetries;
    private final long initialBackoffMillis;
    private final long maxBackoffMillis;
    private final double backoffMultiplier;

    public RetryPolicy(int maxRetries, long initialBackoffMillis, long maxBackoffMillis, double backoffMultiplier) {
        this.maxRetries = Math.max(0, maxRetries);
        this.initialBackoffMillis = Math.max(0L, initialBackoffMillis);
        this.maxBackoffMillis = Math.max(initialBackoffMillis, maxBackoffMillis);
        this.backoffMultiplier = backoffMultiplier <= 1.0 ? 2.0 : backoffMultiplier;
    }

    public static RetryPolicy defaultPolicy() {
        return new RetryPolicy(3, 500L, 5000L, 2.0);
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public long getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }
}

