/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.info;

import io.github.hyperliquid.sdk.utils.HypeError;
import java.time.Duration;

public enum CandleInterval {
    MINUTE_1("1m", Duration.ofMinutes(1L)),
    MINUTE_3("3m", Duration.ofMinutes(3L)),
    MINUTE_5("5m", Duration.ofMinutes(5L)),
    MINUTE_15("15m", Duration.ofMinutes(15L)),
    MINUTE_30("30m", Duration.ofMinutes(30L)),
    HOUR_1("1h", Duration.ofHours(1L)),
    HOUR_2("2h", Duration.ofHours(2L)),
    HOUR_4("4h", Duration.ofHours(4L)),
    HOUR_8("8h", Duration.ofHours(8L)),
    HOUR_12("12h", Duration.ofHours(12L)),
    DAY_1("1d", Duration.ofDays(1L)),
    DAY_3("3d", Duration.ofDays(3L)),
    WEEK_1("1w", Duration.ofDays(7L)),
    MONTH_1("1M", Duration.ofDays(30L));

    private final String code;
    private final Duration duration;

    private CandleInterval(String code, Duration duration) {
        this.code = code;
        this.duration = duration;
    }

    public String getCode() {
        return this.code;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public long toMillis() {
        return this.duration.toMillis();
    }

    public long toSeconds() {
        return this.duration.toSeconds();
    }

    public long toMinutes() {
        return this.duration.toMinutes();
    }

    public static CandleInterval fromCode(String code) {
        if (code == null) {
            throw new HypeError("Interval code cannot be null");
        }
        for (CandleInterval interval : CandleInterval.values()) {
            if (!interval.code.equals(code)) continue;
            return interval;
        }
        throw new HypeError("Unsupported interval code: " + code);
    }

    public static long toMillis(String code) {
        return CandleInterval.fromCode(code).toMillis();
    }
}

