/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.hyperliquid.sdk.utils.HypeError;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.web3j.utils.Numeric;

public class Cloid {
    private final String raw;

    public String getRaw() {
        return this.raw;
    }

    @JsonCreator
    public Cloid(String raw) {
        if (raw == null) {
            throw new HypeError("cloid is not a hex string");
        }
        this.raw = raw;
        this.validate();
    }

    private void validate() {
        if (!this.raw.startsWith("0x")) {
            throw new HypeError("cloid is not a hex string");
        }
        String hex = this.raw.substring(2);
        if (hex.length() != 32) {
            throw new HypeError("cloid is not 16 bytes");
        }
    }

    public static Cloid fromInt(Integer cloid) {
        String hex = Integer.toHexString(cloid);
        String padded = Cloid.leftPad(hex);
        return new Cloid("0x" + padded);
    }

    public static Cloid fromLong(Long cloid) {
        String hex = Long.toHexString(cloid);
        String padded = Cloid.leftPad(hex);
        return new Cloid("0x" + padded);
    }

    public static Cloid fromBigInt(BigInteger cloid) {
        if (cloid == null) {
            throw new HypeError("cloid is not a hex string");
        }
        String hex = cloid.toString(16);
        String padded = Cloid.leftPad(hex);
        return new Cloid("0x" + padded);
    }

    public static Cloid fromStr(String cloid) {
        return new Cloid(cloid);
    }

    public static Cloid auto() {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        String hex = Numeric.toHexStringNoPrefix((byte[])bytes);
        String padded = Cloid.leftPad(hex);
        return new Cloid("0x" + padded);
    }

    public static Cloid fromDecimalString(String s) {
        if (s == null) {
            throw new HypeError("cloid is not a hex string");
        }
        String trimmed = s.trim();
        if (!trimmed.matches("^\\d+$")) {
            throw new HypeError("cloid is not a hex string");
        }
        BigInteger bi = new BigInteger(trimmed);
        if (bi.signum() < 0) {
            throw new HypeError("cloid is not a hex string");
        }
        String hex = bi.toString(16);
        String padded = Cloid.leftPad(hex);
        return new Cloid("0x" + padded);
    }

    @JsonValue
    public String toRaw() {
        return this.raw;
    }

    public String toString() {
        return this.raw;
    }

    private static String leftPad(String s) {
        if (s == null) {
            s = "";
        }
        if (s.length() >= 32) {
            return s.substring(s.length() - 32);
        }
        return String.valueOf('0').repeat(32 - s.length()) + s;
    }
}

