/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.order.InstrumentType;
import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.OrderBuilder;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.OrderWithTpSlBuilder;
import io.github.hyperliquid.sdk.model.order.Tif;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;

public class OrderRequest {
    private InstrumentType instrumentType;
    private String coin;
    private Boolean isBuy;
    private String sz;
    private String limitPx;
    private OrderType orderType;
    private Boolean reduceOnly;
    private Cloid cloid;
    private String slippage = "0.05";
    private Long expiresAfter;

    public OrderRequest() {
    }

    public OrderRequest(InstrumentType instrumentType, String coin, Boolean isBuy, String sz, String limitPx, OrderType orderType, Boolean reduceOnly, Cloid cloid) {
        this.instrumentType = instrumentType;
        this.coin = coin;
        this.isBuy = isBuy;
        this.sz = sz;
        this.limitPx = limitPx;
        this.orderType = orderType;
        this.reduceOnly = reduceOnly;
        this.cloid = cloid;
    }

    public OrderRequest(InstrumentType instrumentType, String coin, Boolean isBuy, String sz, String limitPx, OrderType orderType, Boolean reduceOnly, Cloid cloid, String slippage) {
        this.instrumentType = instrumentType;
        this.coin = coin;
        this.isBuy = isBuy;
        this.sz = sz;
        this.limitPx = limitPx;
        this.orderType = orderType;
        this.reduceOnly = reduceOnly;
        this.cloid = cloid;
        this.slippage = slippage;
    }

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    public static OrderWithTpSlBuilder entryWithTpSl() {
        return new OrderWithTpSlBuilder();
    }

    public InstrumentType getInstrumentType() {
        return this.instrumentType;
    }

    public void setInstrumentType(InstrumentType instrumentType) {
        this.instrumentType = instrumentType;
    }

    public String getCoin() {
        return this.coin;
    }

    public void setCoin(String coin) {
        this.coin = coin;
    }

    public Boolean getIsBuy() {
        return this.isBuy;
    }

    public void setIsBuy(Boolean isBuy) {
        this.isBuy = isBuy;
    }

    public String getSz() {
        return this.sz;
    }

    public void setSz(String sz) {
        this.sz = sz;
    }

    public String getLimitPx() {
        return this.limitPx;
    }

    public void setLimitPx(String limitPx) {
        this.limitPx = limitPx;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public Boolean getReduceOnly() {
        return this.reduceOnly;
    }

    public void setReduceOnly(Boolean reduceOnly) {
        this.reduceOnly = reduceOnly;
    }

    public Cloid getCloid() {
        return this.cloid;
    }

    public void setCloid(Cloid cloid) {
        this.cloid = cloid;
    }

    public String getSlippage() {
        return this.slippage;
    }

    public void setSlippage(String slippage) {
        this.slippage = slippage;
    }

    public Long getExpiresAfter() {
        return this.expiresAfter;
    }

    public void setExpiresAfter(Long expiresAfter) {
        this.expiresAfter = expiresAfter;
    }

    public static class Close {
        public static OrderRequest market(String coin, String sz) {
            return Close.market(coin, sz, null);
        }

        public static OrderRequest market(String coin, String sz, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setSz(sz);
            req.setReduceOnly(true);
            req.setCloid(cloid);
            LimitOrderType limitOrderType = new LimitOrderType(Tif.IOC);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest market(String coin, boolean isBuy, String sz) {
            return Close.market(coin, isBuy, sz, null);
        }

        public static OrderRequest market(String coin, boolean isBuy, String sz, Cloid cloid) {
            OrderRequest req = Close.market(coin, sz, cloid);
            req.setIsBuy(isBuy);
            return req;
        }

        public static OrderRequest marketAll(String coin) {
            return Close.marketAll(coin, null);
        }

        public static OrderRequest marketAll(String coin, Cloid cloid) {
            return Close.market(coin, null, cloid);
        }

        public static OrderRequest limit(String coin, String sz, String limitPx) {
            return Close.limit(Tif.GTC, coin, null, sz, limitPx, null);
        }

        public static OrderRequest limit(String coin, String sz, String limitPx, Cloid cloid) {
            return Close.limit(Tif.GTC, coin, null, sz, limitPx, cloid);
        }

        public static OrderRequest limit(Tif tif, String coin, Boolean isBuy, String sz, String limitPx, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(limitPx);
            req.setReduceOnly(true);
            req.setCloid(cloid);
            LimitOrderType limitOrderType = new LimitOrderType(tif);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest takeProfit(String coin, Boolean isBuy, String sz, String triggerPx) {
            return Close.takeProfit(coin, isBuy, sz, triggerPx, null);
        }

        public static OrderRequest takeProfitForLong(String coin, String sz, String triggerPx) {
            return Close.takeProfit(coin, false, sz, triggerPx, null);
        }

        public static OrderRequest takeProfitForShort(String coin, String sz, String triggerPx) {
            return Close.takeProfit(coin, true, sz, triggerPx, null);
        }

        public static OrderRequest takeProfit(String coin, Boolean isBuy, String sz, String triggerPx, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(triggerPx);
            req.setReduceOnly(true);
            req.setCloid(cloid);
            TriggerOrderType triggerOrderType = new TriggerOrderType(triggerPx, true, TriggerOrderType.TpslType.TP);
            OrderType orderType = new OrderType(triggerOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest stopLoss(String coin, Boolean isBuy, String sz, String triggerPx) {
            return Close.stopLoss(coin, isBuy, sz, triggerPx, null);
        }

        public static OrderRequest stopLossForLong(String coin, String sz, String triggerPx) {
            return Close.stopLoss(coin, false, sz, triggerPx, null);
        }

        public static OrderRequest stopLossForShort(String coin, String sz, String triggerPx) {
            return Close.stopLoss(coin, true, sz, triggerPx, null);
        }

        public static OrderRequest stopLoss(String coin, Boolean isBuy, String sz, String triggerPx, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(null);
            req.setReduceOnly(true);
            req.setCloid(cloid);
            TriggerOrderType triggerOrderType = new TriggerOrderType(triggerPx, true, TriggerOrderType.TpslType.SL);
            OrderType orderType = new OrderType(triggerOrderType);
            req.setOrderType(orderType);
            return req;
        }
    }

    public static class Open {
        public static OrderRequest market(String coin, boolean isBuy, String sz) {
            return Open.market(coin, isBuy, sz, null);
        }

        public static OrderRequest market(String coin, boolean isBuy, String sz, Cloid cloid) {
            OrderRequest req = Open.createMarket(InstrumentType.PERP, coin, isBuy, sz);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest limit(String coin, boolean isBuy, String sz, String limitPx) {
            return Open.limit(Tif.GTC, coin, isBuy, sz, limitPx, null);
        }

        public static OrderRequest limit(String coin, boolean isBuy, String sz, String limitPx, Cloid cloid) {
            return Open.limit(Tif.GTC, coin, isBuy, sz, limitPx, cloid);
        }

        public static OrderRequest limit(Tif tif, String coin, boolean isBuy, String sz, String limitPx) {
            return Open.limit(tif, coin, isBuy, sz, limitPx, null);
        }

        public static OrderRequest limit(Tif tif, String coin, boolean isBuy, String sz, String limitPx, Cloid cloid) {
            OrderRequest req = Open.createLimit(InstrumentType.PERP, tif, coin, isBuy, sz, limitPx);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest breakout(String coin, Boolean isBuy, String sz, String triggerPx, Cloid cloid) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(InstrumentType.PERP);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(triggerPx);
            req.setReduceOnly(false);
            req.setCloid(cloid);
            TriggerOrderType triggerOrderType = new TriggerOrderType(triggerPx, true, TriggerOrderType.TpslType.SL);
            OrderType orderType = new OrderType(triggerOrderType);
            req.setOrderType(orderType);
            return req;
        }

        public static OrderRequest breakoutAbove(String coin, String sz, String triggerPx) {
            return Open.breakout(coin, true, sz, triggerPx, null);
        }

        public static OrderRequest breakoutBelow(String coin, String sz, String triggerPx) {
            return Open.breakout(coin, false, sz, triggerPx, null);
        }

        public static OrderRequest spotMarketBuy(String coin, String sz) {
            return Open.spotMarketBuy(coin, sz, null);
        }

        public static OrderRequest spotMarketBuy(String coin, String sz, Cloid cloid) {
            OrderRequest req = Open.createMarket(InstrumentType.SPOT, coin, true, sz);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest spotMarketSell(String coin, String sz) {
            return Open.spotMarketSell(coin, sz, null);
        }

        public static OrderRequest spotMarketSell(String coin, String sz, Cloid cloid) {
            OrderRequest req = Open.createMarket(InstrumentType.SPOT, coin, false, sz);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest spotLimitBuy(String coin, String sz, String limitPx) {
            return Open.spotLimitBuy(coin, sz, limitPx, null);
        }

        public static OrderRequest spotLimitBuy(String coin, String sz, String limitPx, Cloid cloid) {
            OrderRequest req = Open.createLimit(InstrumentType.SPOT, Tif.GTC, coin, true, sz, limitPx);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest spotLimitBuy(Tif tif, String coin, String sz, String limitPx) {
            return Open.spotLimitBuy(tif, coin, sz, limitPx, null);
        }

        public static OrderRequest spotLimitBuy(Tif tif, String coin, String sz, String limitPx, Cloid cloid) {
            OrderRequest req = Open.createLimit(InstrumentType.SPOT, tif, coin, true, sz, limitPx);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest spotLimitSell(String coin, String sz, String limitPx) {
            return Open.spotLimitSell(coin, sz, limitPx, null);
        }

        public static OrderRequest spotLimitSell(String coin, String sz, String limitPx, Cloid cloid) {
            OrderRequest req = Open.createLimit(InstrumentType.SPOT, Tif.GTC, coin, false, sz, limitPx);
            req.setCloid(cloid);
            return req;
        }

        public static OrderRequest spotLimitSell(Tif tif, String coin, String sz, String limitPx) {
            return Open.spotLimitSell(tif, coin, sz, limitPx, null);
        }

        public static OrderRequest spotLimitSell(Tif tif, String coin, String sz, String limitPx, Cloid cloid) {
            OrderRequest req = Open.createLimit(InstrumentType.SPOT, tif, coin, false, sz, limitPx);
            req.setCloid(cloid);
            return req;
        }

        private static OrderRequest createMarket(InstrumentType instrumentType, String coin, boolean isBuy, String sz) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(instrumentType);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setReduceOnly(false);
            LimitOrderType limitOrderType = new LimitOrderType(Tif.IOC);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }

        private static OrderRequest createLimit(InstrumentType instrumentType, Tif tif, String coin, boolean isBuy, String sz, String limitPx) {
            OrderRequest req = new OrderRequest();
            req.setInstrumentType(instrumentType);
            req.setCoin(coin);
            req.setIsBuy(isBuy);
            req.setSz(sz);
            req.setLimitPx(limitPx);
            req.setReduceOnly(false);
            LimitOrderType limitOrderType = new LimitOrderType(tif);
            OrderType orderType = new OrderType(limitOrderType);
            req.setOrderType(orderType);
            return req;
        }
    }
}

