/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import io.github.hyperliquid.sdk.model.order.Cloid;
import io.github.hyperliquid.sdk.model.order.InstrumentType;
import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.OrderRequest;
import io.github.hyperliquid.sdk.model.order.OrderType;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;

public class OrderBuilder {
    private InstrumentType instrumentType;
    private String coin;
    private Boolean isBuy;
    private String sz;
    private String limitPx;
    private OrderType orderType;
    private Boolean reduceOnly = false;
    private Cloid cloid;
    private String slippage;
    private Long expiresAfter;

    public OrderBuilder expiresAfter(Long expiresAfter) {
        this.expiresAfter = expiresAfter;
        return this;
    }

    public OrderBuilder perp(String coin) {
        this.instrumentType = InstrumentType.PERP;
        this.coin = coin;
        return this;
    }

    public OrderBuilder spot(String coin) {
        this.instrumentType = InstrumentType.SPOT;
        this.coin = coin;
        return this;
    }

    public OrderBuilder buy(String sz) {
        this.isBuy = true;
        this.sz = sz;
        return this;
    }

    public OrderBuilder sell(String sz) {
        this.isBuy = false;
        this.sz = sz;
        return this;
    }

    public OrderBuilder limitPrice(String limitPx) {
        this.limitPx = limitPx;
        return this.orderType(LimitOrderType.gtc());
    }

    public OrderBuilder market() {
        this.limitPx = null;
        return this.orderType(LimitOrderType.ioc());
    }

    public OrderBuilder market(String slippage) {
        this.limitPx = null;
        this.slippage = slippage;
        return this.orderType(LimitOrderType.ioc());
    }

    public OrderBuilder stopAbove(String triggerPx) {
        return this.orderType(TriggerOrderType.tp(triggerPx, false));
    }

    public OrderBuilder stopBelow(String triggerPx) {
        return this.orderType(TriggerOrderType.sl(triggerPx, false));
    }

    public OrderBuilder orderType(TriggerOrderType trigger) {
        this.orderType = new OrderType(trigger);
        return this;
    }

    public OrderBuilder orderType(LimitOrderType limit) {
        this.orderType = new OrderType(limit);
        return this;
    }

    public OrderBuilder reduceOnly() {
        this.reduceOnly = true;
        return this;
    }

    public OrderBuilder cloid(Cloid cloid) {
        this.cloid = cloid;
        return this;
    }

    public OrderBuilder autoCloid() {
        this.cloid = Cloid.auto();
        return this;
    }

    public OrderRequest build() {
        if (this.coin == null || this.coin.isEmpty()) {
            throw new IllegalStateException("coin is required");
        }
        if (this.isBuy == null) {
            throw new IllegalStateException("direction is required (call buy() or sell())");
        }
        if (this.sz == null || this.sz.isEmpty()) {
            throw new IllegalStateException("size is required");
        }
        if (this.orderType == null) {
            this.orderType = new OrderType(LimitOrderType.gtc());
        }
        OrderRequest req = new OrderRequest(this.instrumentType != null ? this.instrumentType : InstrumentType.PERP, this.coin, this.isBuy, this.sz, this.limitPx, this.orderType, this.reduceOnly, this.cloid);
        if (this.slippage != null) {
            req.setSlippage(this.slippage);
        }
        if (this.expiresAfter != null) {
            req.setExpiresAfter(this.expiresAfter);
        }
        return req;
    }
}

