/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.order;

import io.github.hyperliquid.sdk.model.order.LimitOrderType;
import io.github.hyperliquid.sdk.model.order.Tif;
import io.github.hyperliquid.sdk.model.order.TriggerOrderType;

public class OrderType {
    private final LimitOrderType limit;
    private final TriggerOrderType trigger;

    public OrderType(LimitOrderType limit, TriggerOrderType trigger) {
        this.limit = limit;
        this.trigger = trigger;
    }

    public OrderType(LimitOrderType limit) {
        this.limit = limit;
        this.trigger = null;
    }

    public OrderType(TriggerOrderType trigger) {
        this.trigger = trigger;
        this.limit = null;
    }

    public static OrderType limitByGtc() {
        return new OrderType(new LimitOrderType(Tif.GTC));
    }

    public static OrderType limitByAlo() {
        return new OrderType(new LimitOrderType(Tif.ALO));
    }

    public static OrderType limitByIoc() {
        return new OrderType(new LimitOrderType(Tif.IOC));
    }

    public static OrderType trigger(TriggerOrderType trigger) {
        return new OrderType(trigger);
    }

    public LimitOrderType getLimit() {
        return this.limit;
    }

    public TriggerOrderType getTrigger() {
        return this.trigger;
    }
}

