/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.model.subscription;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.hyperliquid.sdk.model.subscription.Subscription;
import java.util.Locale;

public class CandleSubscription
extends Subscription {
    @JsonProperty(value="type")
    private final String type = "candle";
    @JsonProperty(value="coin")
    private String coin;
    @JsonProperty(value="interval")
    private String interval;

    public CandleSubscription() {
    }

    public CandleSubscription(String coin, String interval) {
        this.coin = coin;
        this.interval = interval;
    }

    public static CandleSubscription of(String coin, String interval) {
        return new CandleSubscription(coin, interval);
    }

    @Override
    public String getType() {
        return "candle";
    }

    public String getCoin() {
        return this.coin;
    }

    public void setCoin(String coin) {
        this.coin = coin;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    @Override
    public String toIdentifier() {
        if (this.coin == null || this.interval == null) {
            return "candle";
        }
        String coinKey = this.coin.toLowerCase(Locale.ROOT);
        return "candle:" + coinKey + "," + this.interval;
    }
}

