/*
 * Decompiled with CFR 0.152.
 */
package io.github.hyperliquid.sdk.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.List;

public class JSONUtil {
    private static final ObjectMapper mapper = JSONUtil.createSharedMapper();

    private static ObjectMapper createSharedMapper() {
        ObjectMapper om = new ObjectMapper();
        om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        om.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        om.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        om.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return om;
    }

    public static synchronized void registerModule(Module module) {
        if (module != null) {
            mapper.registerModule(module);
        }
    }

    public static JsonNode readTree(String resp) throws JsonProcessingException {
        return mapper.readTree(resp);
    }

    public static String writeValueAsString(Object payload) throws JsonProcessingException {
        return mapper.writeValueAsString(payload);
    }

    public static <T> T treeToValue(TreeNode var1, Class<T> var2) throws JsonProcessingException {
        return (T)mapper.treeToValue(var1, var2);
    }

    public static <T> T treeToValue(Object fromValue, Class<T> toValueType) {
        return (T)mapper.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(JsonNode node, MapType mapType) {
        return (T)mapper.convertValue((Object)node, (JavaType)mapType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) throws IllegalArgumentException {
        return (T)mapper.convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        return (T)mapper.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        return (T)mapper.convertValue(fromValue, toValueType);
    }

    public static byte[] writeValueAsBytes(Object action) throws JsonProcessingException {
        return mapper.writeValueAsBytes(action);
    }

    public static <T> T readValue(JsonParser var1, Class<T> var2) throws IOException {
        return (T)mapper.readValue(var1, var2);
    }

    public static <T> T readValue(String content, Class<T> valueType) throws JsonProcessingException {
        return (T)mapper.readValue(content, valueType);
    }

    public static <T> List<T> toList(JsonNode jsonNode, Class<T> valueType) {
        return (List)mapper.convertValue((Object)jsonNode, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, valueType));
    }
}

