/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnexpectedException;
import net.infobank.client.data.request.common.Fallback;
import net.infobank.client.data.request.rcs.content.Carousel;
import net.infobank.client.data.request.rcs.content.Standalone;
import net.infobank.client.data.request.rcs.content.Template;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class RcsRequest {
    private final Object content;
    private final String from;
    private final String to;
    private final String formatId;
    private final String brandKey;
    private final String brandId;
    private final String expiryOption;
    private final String header;
    private final String footer;
    private final String ref;
    private final Fallback fallback;

    @JsonProperty(value="content")
    public Object getContent() {
        return this.content;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="formatId")
    public String getFormatId() {
        return this.formatId;
    }

    @JsonProperty(value="brandKey")
    public String getBrandKey() {
        return this.brandKey;
    }

    @JsonProperty(value="brandId")
    public String getBrandId() {
        return this.brandId;
    }

    @JsonProperty(value="expiryOption")
    public String getExpiryOption() {
        return this.expiryOption;
    }

    @JsonProperty(value="header")
    public String getHeader() {
        return this.header;
    }

    @JsonProperty(value="footer")
    public String getFooter() {
        return this.footer;
    }

    @JsonProperty(value="ref")
    public String getRef() {
        return this.ref;
    }

    @JsonProperty(value="fallback")
    public Fallback getFallback() {
        return this.fallback;
    }

    private RcsRequest(Builder builder) {
        this.content = builder.content;
        this.from = builder.from;
        this.to = builder.to;
        this.formatId = builder.formatId;
        this.brandKey = builder.brandKey;
        this.brandId = builder.brandId;
        this.expiryOption = builder.expiryOption;
        this.header = builder.header;
        this.footer = builder.footer;
        this.ref = builder.ref;
        this.fallback = builder.fallback;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public static class Builder {
        private Object content;
        private String from;
        private String to;
        private String formatId;
        private String brandKey;
        private String brandId;
        private String expiryOption;
        private String header;
        private String footer;
        private String ref;
        private Fallback fallback;

        public Builder content(Standalone standalone) {
            this.content = standalone;
            return this;
        }

        public Builder content(Carousel carousel) {
            this.content = carousel;
            return this;
        }

        public Builder content(Template template) {
            this.content = template;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder formatId(String formatId) {
            this.formatId = formatId;
            return this;
        }

        public Builder brandKey(String brandKey) {
            this.brandKey = brandKey;
            return this;
        }

        public Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public Builder expiryOption(String expiryOption) {
            this.expiryOption = expiryOption;
            return this;
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public Builder fallback(Fallback fallback) {
            this.fallback = fallback;
            return this;
        }

        public RcsRequest build() {
            if (this.content == null) {
                throw new MissingFieldException("content field must not be null");
            }
            if (this.from == null) {
                throw new MissingFieldException("from field must not be null");
            }
            if (this.to == null) {
                throw new MissingFieldException("to field must not be null");
            }
            if (this.formatId == null) {
                throw new MissingFieldException("formatId field must not be null");
            }
            if (this.brandKey == null) {
                throw new MissingFieldException("brandKey field must not be null");
            }
            return new RcsRequest(this);
        }
    }
}

