/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.core.exception.MissingFieldException;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class MmsMessage {
    final MmsData mms;

    @JsonProperty(value="mms")
    public MmsData getMms() {
        return this.mms;
    }

    MmsMessage(Builder builder) {
        this.mms = new MmsData(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String from;
        List<String> fileKey = new ArrayList<String>();
        String title;
        String text;
        String ttl;
        String originCID;

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder addFileKey(String fileKey) {
            this.fileKey.add(fileKey);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder originCID(String originCID) {
            this.originCID = originCID;
            return this;
        }

        public MmsMessage build() {
            if (this.from == null) {
                throw new MissingFieldException("from field must not be null");
            }
            if (this.text == null) {
                throw new MissingFieldException("text field must not be null");
            }
            return new MmsMessage(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private class MmsData {
        String from;
        List<String> fileKey;
        String title;
        String text;
        String ttl;
        String originCID;

        MmsData(Builder builder) {
            this.from = builder.from;
            this.fileKey = builder.fileKey;
            this.title = builder.title;
            this.text = builder.text;
            this.ttl = builder.ttl;
            this.originCID = builder.originCID;
        }

        @JsonProperty(value="from")
        public String getFrom() {
            return this.from;
        }

        @JsonProperty(value="fileKey")
        public List<String> getFileKey() {
            return this.fileKey;
        }

        @JsonProperty(value="title")
        public String getTitle() {
            return this.title;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="ttl")
        public String getTtl() {
            return this.ttl;
        }

        @JsonProperty(value="originCID")
        public String getOriginCID() {
            return this.originCID;
        }
    }
}

