/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.code;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum MessageType {
    SM,
    LM,
    MM,
    IM,
    RS,
    RL,
    RM,
    RF,
    RD,
    RC,
    RI,
    AT,
    AI,
    FT,
    FI,
    FW,
    FL,
    FC,
    FM,
    FA,
    FP,
    DEFAULT("default"),
    WIDE("wide"),
    WIDE_ITEM_LIST("wideItemList"),
    CAROUSEL_FEED("carouselFeed"),
    CAROUSEL_COMMERCE("carouselCommerce");

    private final String jsonValue;

    private MessageType() {
        this.jsonValue = this.name().toLowerCase();
    }

    private MessageType(String jsonValue) {
        this.jsonValue = jsonValue;
    }

    @JsonValue
    public String toJson() {
        return this.jsonValue;
    }

    @JsonCreator
    public static MessageType fromJson(String value) {
        for (MessageType type : MessageType.values()) {
            if (!type.jsonValue.equalsIgnoreCase(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown MessageType: " + value);
    }

    public String toString() {
        return this.jsonValue;
    }
}

