/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnexpectedException;
import net.infobank.client.data.code.FallbackType;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Fallback {
    final String type;
    final String from;
    final String text;
    final String title;
    final List<String> fileKey;
    final String originCID;

    Fallback(Builder builder) {
        this.type = builder.type.toString();
        this.from = builder.from;
        this.text = builder.text;
        this.title = builder.title;
        this.fileKey = builder.fileKey;
        this.originCID = builder.originCID;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="fileKey")
    public List<String> getFileKey() {
        return this.fileKey;
    }

    @JsonProperty(value="originCID")
    public String getOriginCID() {
        return this.originCID;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public static class Builder {
        private FallbackType type;
        private String from;
        private String text;
        private String title;
        private List<String> fileKey = new ArrayList<String>();
        private String originCID;

        Builder() {
        }

        public Builder type(FallbackType type) {
            this.type = type;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder addFileKey(String fileKey) {
            this.fileKey.add(fileKey);
            return this;
        }

        public Builder originCID(String originCID) {
            this.originCID = originCID;
            return this;
        }

        public Fallback build() {
            if (this.type == null) {
                throw new MissingFieldException("type field must not be null");
            }
            if (this.text == null) {
                throw new MissingFieldException("text field must not be null");
            }
            return new Fallback(this);
        }
    }
}

