/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.kakao.attachment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.data.request.kakao.attachment.Commerce;
import net.infobank.client.data.request.kakao.attachment.Coupon;
import net.infobank.client.data.request.kakao.attachment.Image;
import net.infobank.client.data.request.kakao.attachment.Item;
import net.infobank.client.data.request.kakao.attachment.ItemHighlight;
import net.infobank.client.data.request.kakao.attachment.Video;
import net.infobank.client.data.request.kakao.button.Button;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class Attachment {
    final List<Button> button;
    final Item item;
    final ItemHighlight itemHighlight;
    final Image image;
    final Coupon coupon;
    final Commerce commerce;
    final Video video;

    public Attachment(Builder builder) {
        this.button = builder.button;
        this.item = builder.item;
        this.itemHighlight = builder.itemHighlight;
        this.image = builder.image;
        this.coupon = builder.coupon;
        this.commerce = builder.commerce;
        this.video = builder.video;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty(value="button")
    public List<Button> getButton() {
        return this.button;
    }

    @JsonProperty(value="item")
    public Item getItem() {
        return this.item;
    }

    @JsonProperty(value="itemHighlight")
    public ItemHighlight getItemHighlight() {
        return this.itemHighlight;
    }

    @JsonProperty(value="image")
    public Image getImage() {
        return this.image;
    }

    @JsonProperty(value="coupon")
    public Coupon getCoupon() {
        return this.coupon;
    }

    @JsonProperty(value="commerce")
    public Commerce getCommerce() {
        return this.commerce;
    }

    @JsonProperty(value="video")
    public Video getVideo() {
        return this.video;
    }

    public static class Builder {
        private List<Button> button = new ArrayList<Button>();
        private Item item;
        private ItemHighlight itemHighlight;
        private Image image;
        private Coupon coupon;
        private Commerce commerce;
        private Video video;

        public Builder addButton(Button button) {
            this.button.add(button);
            return this;
        }

        public Builder item(Item item) {
            this.item = item;
            return this;
        }

        public Builder itemHighlight(ItemHighlight itemHighlight) {
            this.itemHighlight = itemHighlight;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public Builder coupon(Coupon coupon) {
            this.coupon = coupon;
            return this;
        }

        public Builder commerce(Commerce commerce) {
            this.commerce = commerce;
            return this;
        }

        public Builder video(Video video) {
            this.video = video;
            return this;
        }

        public Attachment build() {
            return new Attachment(this);
        }
    }
}

