/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.MethodFailedException;
import net.infobank.client.core.exception.ResponseParseException;
import net.infobank.client.core.exception.UnexpectedException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public abstract class AbstractMethod<RequestT, ResponseT> {
    protected static final BasicResponseHandler basicResponseHandler = new BasicResponseHandler();
    protected final HttpWrapper httpWrapper;

    public AbstractMethod(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    public ResponseT execute(RequestT request) {
        try {
            HttpUriRequest httpRequest = this.applyAuth(this.makeRequest(request)).setHeader("User-Agent", this.httpWrapper.getHttpConfig().getUserAgent()).setCharset(StandardCharsets.UTF_8).build();
            HttpResponse response = this.httpWrapper.getHttpClient().execute(httpRequest);
            try {
                return this.parseResponse(response);
            }
            catch (IOException io) {
                throw new ResponseParseException("Unable to parse response.", io);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new UnexpectedException("UTF-8 encoding is not supported by this JVM.", uee);
        }
        catch (IOException io) {
            throw new MethodFailedException("Something went wrong while executing the HTTP request: " + io.getMessage() + ".", io);
        }
    }

    protected RequestBuilder applyAuth(RequestBuilder request) throws IOException {
        return this.httpWrapper.applyAuth(request);
    }

    public void setHttpClient(HttpClient client) {
        this.httpWrapper.setHttpClient(client);
    }

    public abstract RequestBuilder makeRequest(RequestT var1) throws UnsupportedEncodingException;

    public abstract ResponseT parseResponse(HttpResponse var1) throws IOException;
}

