/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.core;

import java.io.IOException;
import net.infobank.client.core.HttpConfig;
import net.infobank.client.core.Util;
import net.infobank.client.service.auth.AuthService;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;

public class HttpWrapper {
    private HttpClient httpClient;
    private HttpConfig httpConfig;
    private AuthService authService;

    public HttpWrapper(HttpConfig httpConfig, AuthService authService) {
        this.httpConfig = httpConfig;
        this.authService = authService;
    }

    public HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = Util.createHttpClient(this.httpConfig);
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public RequestBuilder applyAuth(RequestBuilder request) throws IOException {
        return this.authService.init(request);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public AuthService getAuthService() {
        return this.authService;
    }

    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }
}

