/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.code;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.EnumSet;
import java.util.Set;
import net.infobank.client.data.code.MessageType;

public enum ServiceType {
    SMS(MessageType.SM, new MessageType[0]),
    MMS(MessageType.LM, MessageType.MM),
    INTERNATIONAL(MessageType.IM, new MessageType[0]),
    RCS(MessageType.RS, MessageType.RL, MessageType.RM, MessageType.RF, MessageType.RD, MessageType.RC, MessageType.RI),
    ALIMTALK(MessageType.AT, MessageType.AI),
    FRIENDTALK(MessageType.FT, MessageType.FI, MessageType.FW, MessageType.FL, MessageType.FC, MessageType.FM, MessageType.FA, MessageType.FP),
    BRANDMESSAGE(MessageType.FT, MessageType.FI, MessageType.FW, MessageType.FL, MessageType.FC, MessageType.FM, MessageType.FA, MessageType.FP, MessageType.DEFAULT, MessageType.WIDE, MessageType.WIDE_ITEM_LIST, MessageType.CAROUSEL_COMMERCE, MessageType.CAROUSEL_FEED),
    OMNI(MessageType.SM, MessageType.LM, MessageType.MM, MessageType.IM, MessageType.RS, MessageType.RL, MessageType.RM, MessageType.RF, MessageType.RD, MessageType.RC, MessageType.RI, MessageType.AT, MessageType.AI, MessageType.FT, MessageType.FI, MessageType.FW, MessageType.FL, MessageType.FC, MessageType.FM, MessageType.FA, MessageType.FP, MessageType.DEFAULT, MessageType.WIDE, MessageType.WIDE_ITEM_LIST, MessageType.CAROUSEL_COMMERCE, MessageType.CAROUSEL_FEED);

    private final Set<MessageType> supportedTypes;

    private ServiceType(MessageType type1, MessageType ... additionalTypes) {
        this.supportedTypes = EnumSet.of(type1, additionalTypes);
    }

    public Set<MessageType> getSupportedMessageTypes() {
        return this.supportedTypes;
    }

    public boolean supports(MessageType messageType) {
        return this.supportedTypes.contains((Object)messageType);
    }

    @JsonCreator
    public static ServiceType fromString(String value) {
        if (value == null) {
            return null;
        }
        return ServiceType.valueOf(value.toUpperCase());
    }

    @JsonValue
    public String toString() {
        return this.name();
    }
}

