/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnexpectedException;
import net.infobank.client.core.exception.UnsupportedMessageException;
import net.infobank.client.data.code.MessageType;
import net.infobank.client.data.code.ServiceType;
import net.infobank.client.data.request.common.Fallback;
import net.infobank.client.data.request.kakao.button.Button;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class BrandmessageRequest {
    final String senderKey;
    final String sendType;
    final String msgType;
    final String to;
    final String text;
    final String imgUrl;
    final String targeting;
    final String templateCode;
    final List<Button> button;
    final Fallback fallback;
    final String groupTagKey;
    final String adult;
    final String pushAlarm;
    final JsonNode messageVariable;
    final JsonNode buttonVariable;
    final JsonNode couponVariable;
    final JsonNode imageVariable;
    final JsonNode videoVariable;
    final JsonNode commerceVariable;
    final JsonNode carouselVariable;
    final String originCID;
    final String unsubscribePhoneNumber;
    final String unsubscribeAuthNumber;
    final String ref;

    BrandmessageRequest(Builder builder) {
        this.senderKey = builder.senderKey;
        this.sendType = builder.sendType;
        this.msgType = builder.msgType.toString();
        this.to = builder.to;
        this.text = builder.text;
        this.imgUrl = builder.imgUrl;
        this.targeting = builder.targeting;
        this.templateCode = builder.templateCode;
        this.button = builder.button;
        this.fallback = builder.fallback;
        this.groupTagKey = builder.groupTagKey;
        this.adult = builder.adult;
        this.pushAlarm = builder.pushAlarm;
        this.messageVariable = builder.messageVariable;
        this.buttonVariable = builder.buttonVariable;
        this.couponVariable = builder.couponVariable;
        this.imageVariable = builder.imageVariable;
        this.videoVariable = builder.videoVariable;
        this.commerceVariable = builder.commerceVariable;
        this.carouselVariable = builder.carouselVariable;
        this.originCID = builder.originCID;
        this.unsubscribePhoneNumber = builder.unsubscribePhoneNumber;
        this.unsubscribeAuthNumber = builder.unsubscribeAuthNumber;
        this.ref = builder.ref;
    }

    @JsonProperty(value="senderKey")
    public String getSenderKey() {
        return this.senderKey;
    }

    public String getSendType() {
        return this.sendType;
    }

    @JsonProperty(value="msgType")
    public String getMsgType() {
        return this.msgType;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="imgUrl")
    public String getImgUrl() {
        return this.imgUrl;
    }

    @JsonProperty(value="targeting")
    public String getTargeting() {
        return this.targeting;
    }

    @JsonProperty(value="templateCode")
    public String getTemplateCode() {
        return this.templateCode;
    }

    @JsonProperty(value="button")
    public List<Button> getButton() {
        return this.button;
    }

    @JsonProperty(value="fallback")
    public Fallback getFallback() {
        return this.fallback;
    }

    @JsonProperty(value="groupTagKey")
    public String getGroupTagKey() {
        return this.groupTagKey;
    }

    @JsonProperty(value="adults")
    public String getAdult() {
        return this.adult;
    }

    @JsonProperty(value="pushAlarm")
    public String getPushAlarm() {
        return this.pushAlarm;
    }

    @JsonProperty(value="messageVariable")
    public JsonNode getMessageVariable() {
        return this.messageVariable;
    }

    @JsonProperty(value="buttonVariable")
    public JsonNode getButtonVariable() {
        return this.buttonVariable;
    }

    @JsonProperty(value="couponVariable")
    public JsonNode getCouponVariable() {
        return this.couponVariable;
    }

    @JsonProperty(value="imageVariable")
    public JsonNode getImageVariable() {
        return this.imageVariable;
    }

    @JsonProperty(value="videoVariable")
    public JsonNode getVideoVariable() {
        return this.videoVariable;
    }

    @JsonProperty(value="commerceVariable")
    public JsonNode getCommerceVariable() {
        return this.commerceVariable;
    }

    @JsonProperty(value="carouselVariable")
    public JsonNode getCarouselVariable() {
        return this.carouselVariable;
    }

    @JsonProperty(value="originCID")
    public String getOriginCID() {
        return this.originCID;
    }

    @JsonProperty(value="unsubscribePhoneNumber")
    public String getUnsubscribePhoneNumber() {
        return this.unsubscribePhoneNumber;
    }

    @JsonProperty(value="unsubscribeAuthNumber")
    public String getUnsubscribeAuthNumber() {
        return this.unsubscribeAuthNumber;
    }

    @JsonProperty(value="ref")
    public String getRef() {
        return this.ref;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(this);
        }
        catch (JsonProcessingException jpe) {
            throw new UnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    public static class Builder {
        private String senderKey;
        private String sendType;
        private MessageType msgType;
        private String to;
        private String text;
        private String imgUrl;
        private String targeting;
        private String templateCode;
        private List<Button> button = new ArrayList<Button>();
        private Fallback fallback;
        private String groupTagKey;
        private String adult;
        private String pushAlarm;
        private JsonNode messageVariable;
        private JsonNode buttonVariable;
        private JsonNode couponVariable;
        private JsonNode imageVariable;
        private JsonNode videoVariable;
        private JsonNode commerceVariable;
        private JsonNode carouselVariable;
        private String originCID;
        private String unsubscribePhoneNumber;
        private String unsubscribeAuthNumber;
        private String ref;

        Builder() {
        }

        public Builder senderKey(String senderKey) {
            this.senderKey = senderKey;
            return this;
        }

        public Builder sendType(String sendType) {
            this.sendType = sendType;
            return this;
        }

        public Builder msgType(MessageType msgType) {
            this.msgType = msgType;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder imgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
            return this;
        }

        public Builder targeting(String targeting) {
            this.targeting = targeting;
            return this;
        }

        public Builder templateCode(String templateCode) {
            this.templateCode = templateCode;
            return this;
        }

        public Builder addButton(Button button) {
            this.button.add(button);
            return this;
        }

        public Builder fallback(Fallback fallback) {
            this.fallback = fallback;
            return this;
        }

        public Builder groupTagKey(String groupTagKey) {
            this.groupTagKey = groupTagKey;
            return this;
        }

        public Builder adult(String adult) {
            this.adult = adult;
            return this;
        }

        public Builder pushAlarm(String pushAlarm) {
            this.pushAlarm = pushAlarm;
            return this;
        }

        public Builder messageVariable(JsonNode messageVariable) {
            this.messageVariable = messageVariable;
            return this;
        }

        public Builder buttonVariable(JsonNode buttonVariable) {
            this.buttonVariable = buttonVariable;
            return this;
        }

        public Builder couponVariable(JsonNode couponVariable) {
            this.couponVariable = couponVariable;
            return this;
        }

        public Builder imageVariable(JsonNode imageVariable) {
            this.imageVariable = imageVariable;
            return this;
        }

        public Builder videoVariable(JsonNode videoVariable) {
            this.videoVariable = videoVariable;
            return this;
        }

        public Builder commerceVariable(JsonNode commerceVariable) {
            this.commerceVariable = commerceVariable;
            return this;
        }

        public Builder carouselVariable(JsonNode carouselVariable) {
            this.carouselVariable = carouselVariable;
            return this;
        }

        public Builder originCID(String originCID) {
            this.originCID = originCID;
            return this;
        }

        public Builder unsubscribePhoneNumber(String unsubscribePhoneNumber) {
            this.unsubscribePhoneNumber = unsubscribePhoneNumber;
            return this;
        }

        public Builder unsubscribeAuthNumber(String unsubscribeAuthNumber) {
            this.unsubscribeAuthNumber = unsubscribeAuthNumber;
            return this;
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public BrandmessageRequest build() {
            if (this.senderKey == null) {
                throw new MissingFieldException("senderKey field must not be null");
            }
            if (this.sendType == null) {
                throw new MissingFieldException("sendType field must not be null");
            }
            if (this.msgType == null) {
                throw new MissingFieldException("msgType field must not be null");
            }
            if (this.to == null) {
                throw new MissingFieldException("to field must not be null");
            }
            if (!ServiceType.FRIENDTALK.supports(this.msgType)) {
                throw new UnsupportedMessageException("This msgType is not supported by the BRANDMESSAGE");
            }
            return new BrandmessageRequest(this);
        }
    }
}

