/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.core.exception.UnsupportedMessageException;
import net.infobank.client.data.code.MessageType;
import net.infobank.client.data.code.ServiceType;
import net.infobank.client.data.request.kakao.Carousel;
import net.infobank.client.data.request.kakao.attachment.Attachment;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class FriendtalkMessage {
    final FriendtalkData friendtalk;

    @JsonProperty(value="friendtalk")
    public FriendtalkData getFriendtalk() {
        return this.friendtalk;
    }

    FriendtalkMessage(Builder builder) {
        this.friendtalk = new FriendtalkData(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String senderKey;
        MessageType msgType;
        String text;
        Attachment attachment;
        String adFlag;
        String addtioaddtionalContent;
        String adult;
        String header;
        Carousel carousel;
        String groupTagKey;
        String pushAlarm;

        public Builder senderKey(String senderKey) {
            this.senderKey = senderKey;
            return this;
        }

        public Builder msgType(MessageType msgType) {
            this.msgType = msgType;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder attachment(Attachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public Builder adFlag(String adFlag) {
            this.adFlag = adFlag;
            return this;
        }

        public Builder addtioaddtionalContent(String addtioaddtionalContent) {
            this.addtioaddtionalContent = addtioaddtionalContent;
            return this;
        }

        public Builder adult(String adult) {
            this.adult = adult;
            return this;
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder carousel(Carousel carousel) {
            this.carousel = carousel;
            return this;
        }

        public Builder groupTagKey(String groupTagKey) {
            this.groupTagKey = groupTagKey;
            return this;
        }

        public Builder pushAlarm(String pushAlarm) {
            this.pushAlarm = pushAlarm;
            return this;
        }

        public FriendtalkMessage build() {
            if (this.senderKey == null) {
                throw new MissingFieldException("senderKey field must not be null");
            }
            if (this.msgType == null) {
                throw new MissingFieldException("msgType field must not be null");
            }
            if (!ServiceType.FRIENDTALK.supports(this.msgType)) {
                throw new UnsupportedMessageException("This msgType is not supported by the FRIENDTALK");
            }
            return new FriendtalkMessage(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private class FriendtalkData {
        String senderKey;
        String msgType;
        String text;
        Attachment attachment;
        String adFlag;
        String addtioaddtionalContent;
        String adult;
        String header;
        Carousel carousel;
        String groupTagKey;
        String pushAlarm;

        FriendtalkData(Builder builder) {
            this.senderKey = builder.senderKey;
            this.msgType = builder.msgType.toString();
            this.text = builder.text;
            this.attachment = builder.attachment;
            this.adFlag = builder.adFlag;
            this.addtioaddtionalContent = builder.addtioaddtionalContent;
            this.adult = builder.adult;
            this.header = builder.header;
            this.carousel = builder.carousel;
            this.groupTagKey = builder.groupTagKey;
            this.pushAlarm = builder.pushAlarm;
        }

        @JsonProperty(value="senderKey")
        public String getSenderKey() {
            return this.senderKey;
        }

        @JsonProperty(value="msgType")
        public String getMsgType() {
            return this.msgType;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="attachment")
        public Attachment getAttachment() {
            return this.attachment;
        }

        @JsonProperty(value="adFlag")
        public String getAdFlag() {
            return this.adFlag;
        }

        @JsonProperty(value="addtioaddtionalContent")
        public String getAddtioaddtionalContent() {
            return this.addtioaddtionalContent;
        }

        @JsonProperty(value="adult")
        public String getAdult() {
            return this.adult;
        }

        @JsonProperty(value="header")
        public String getHeader() {
            return this.header;
        }

        @JsonProperty(value="carousel")
        public Carousel getCarousel() {
            return this.carousel;
        }

        @JsonProperty(value="groupTagKey")
        public String getGroupTagKey() {
            return this.groupTagKey;
        }

        @JsonProperty(value="pushAlarm")
        public String getPushAlarm() {
            return this.pushAlarm;
        }
    }
}

