/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.infobank.client.core.exception.MissingFieldException;
import net.infobank.client.data.request.rcs.content.Carousel;
import net.infobank.client.data.request.rcs.content.Standalone;
import net.infobank.client.data.request.rcs.content.Template;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RcsMessage {
    final RcsData rcs;

    @JsonProperty(value="rcs")
    public RcsData getRcs() {
        return this.rcs;
    }

    RcsMessage(Builder builder) {
        this.rcs = new RcsData(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Object content;
        private String from;
        private String formatId;
        private String brandKey;
        private String brandId;
        private String groupId;
        private String expiryOption;
        private String copyAllowed;
        private String header;
        private String footer;
        private String agencyId;
        private String agencyKey;
        private String ttl;

        public Builder content(Standalone standalone) {
            this.content = standalone;
            return this;
        }

        public Builder content(Carousel carousel) {
            this.content = carousel;
            return this;
        }

        public Builder content(Template template) {
            this.content = template;
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder formatId(String formatId) {
            this.formatId = formatId;
            return this;
        }

        public Builder brandKey(String brandKey) {
            this.brandKey = brandKey;
            return this;
        }

        public Builder brandId(String brandId) {
            this.brandId = brandId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        public Builder expiryOption(String expiryOption) {
            this.expiryOption = expiryOption;
            return this;
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public Builder agencyId(String agencyId) {
            this.agencyId = agencyId;
            return this;
        }

        public Builder agencyKey(String agencyKey) {
            this.agencyKey = agencyKey;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public RcsMessage build() {
            if (this.from == null) {
                throw new MissingFieldException("from field must not be null");
            }
            if (this.content == null) {
                throw new MissingFieldException("content field must not be null");
            }
            if (this.formatId == null) {
                throw new MissingFieldException("formatId field must not be null");
            }
            if (this.brandKey == null) {
                throw new MissingFieldException("brandKey field must not be null");
            }
            return new RcsMessage(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private class RcsData {
        private Object content;
        private String from;
        private String formatId;
        private String brandKey;
        private String brandId;
        private String groupId;
        private String expiryOption;
        private String copyAllowed;
        private String header;
        private String footer;
        private String agencyId;
        private String agencyKey;
        private String ttl;

        RcsData(Builder builder) {
            this.content = builder.content;
            this.from = builder.from;
            this.formatId = builder.formatId;
            this.brandKey = builder.brandKey;
            this.brandId = builder.brandId;
            this.groupId = builder.groupId;
            this.expiryOption = builder.expiryOption;
            this.copyAllowed = builder.copyAllowed;
            this.header = builder.header;
            this.footer = builder.footer;
            this.agencyId = builder.agencyId;
            this.agencyKey = builder.agencyKey;
            this.ttl = builder.ttl;
        }

        @JsonProperty(value="content")
        public Object getContent() {
            return this.content;
        }

        @JsonProperty(value="from")
        public String getFrom() {
            return this.from;
        }

        @JsonProperty(value="formatId")
        public String getFormatId() {
            return this.formatId;
        }

        @JsonProperty(value="brandKey")
        public String getBrandKey() {
            return this.brandKey;
        }

        @JsonProperty(value="brandId")
        public String getBrandId() {
            return this.brandId;
        }

        @JsonProperty(value="groupId")
        public String getGroupId() {
            return this.groupId;
        }

        @JsonProperty(value="expiryOption")
        public String getExpiryOption() {
            return this.expiryOption;
        }

        @JsonProperty(value="copyAllowed")
        public String getCopyAllowed() {
            return this.copyAllowed;
        }

        @JsonProperty(value="header")
        public String getHeader() {
            return this.header;
        }

        @JsonProperty(value="footer")
        public String getFooter() {
            return this.footer;
        }

        @JsonProperty(value="agencyId")
        public String getAgencyId() {
            return this.agencyId;
        }

        @JsonProperty(value="agencyKey")
        public String getAgencyKey() {
            return this.agencyKey;
        }

        @JsonProperty(value="ttl")
        public String getTtl() {
            return this.ttl;
        }
    }
}

