/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.data.request.message;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.infobank.client.core.exception.MissingFieldException;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class SmsMessage {
    final SmsData sms;

    @JsonProperty(value="sms")
    public SmsData getSms() {
        return this.sms;
    }

    SmsMessage(Builder builder) {
        this.sms = new SmsData(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        String from;
        String text;
        String ttl;
        String originCID;

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder originCID(String originCID) {
            this.originCID = originCID;
            return this;
        }

        public SmsMessage build() {
            if (this.from == null) {
                throw new MissingFieldException("from field must not be null");
            }
            if (this.text == null) {
                throw new MissingFieldException("text field must not be null");
            }
            return new SmsMessage(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private class SmsData {
        String from;
        String text;
        String ttl;
        String originCID;

        @JsonProperty(value="from")
        public String getFrom() {
            return this.from;
        }

        @JsonProperty(value="text")
        public String getText() {
            return this.text;
        }

        @JsonProperty(value="ttl")
        public String getTtl() {
            return this.ttl;
        }

        @JsonProperty(value="originCID")
        public String getOriginCID() {
            return this.originCID;
        }

        SmsData(Builder builder) {
            this.from = builder.from;
            this.text = builder.text;
            this.ttl = builder.ttl;
            this.originCID = builder.originCID;
        }
    }
}

