/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.report;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.infobank.client.core.AbstractMethod;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.request.ReportInquiryRequest;
import net.infobank.client.data.response.ReportInquiryResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

public class ReportInquiryService
extends AbstractMethod<ReportInquiryRequest, ReportInquiryResponse> {
    private static final String PATH = "/v1/report/inquiry";

    public ReportInquiryService(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(ReportInquiryRequest report) throws UnsupportedEncodingException {
        RequestBuilder request = RequestBuilder.get(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH + "/" + report.getMsgKey()).setHeader("Accept", "application/json");
        return request;
    }

    @Override
    public ReportInquiryResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return ReportInquiryResponse.fromJson(basicResponseHandler.handleResponse(response));
        }
        throw ErrorResponseException.fromHttpResponse(response);
    }
}

