/*
 * Decompiled with CFR 0.152.
 */
package net.infobank.client.service.send;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.infobank.client.core.AbstractMethod;
import net.infobank.client.core.HttpWrapper;
import net.infobank.client.core.exception.ErrorResponseException;
import net.infobank.client.data.request.MmsRequest;
import net.infobank.client.data.response.MmsResponse;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class MmsService
extends AbstractMethod<MmsRequest, MmsResponse> {
    private static final String PATH = "/v1/send/mms";

    public MmsService(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    public RequestBuilder makeRequest(MmsRequest mms) throws UnsupportedEncodingException {
        RequestBuilder request = RequestBuilder.post(this.httpWrapper.getHttpConfig().getBaseUrl() + PATH).setHeader("Content-Type", "application/json").setHeader("Accept", "application/json").setEntity(new StringEntity(mms.toJson(), ContentType.APPLICATION_JSON));
        return request;
    }

    @Override
    public MmsResponse parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200) {
            return MmsResponse.fromJson(basicResponseHandler.handleResponse(response));
        }
        throw ErrorResponseException.fromHttpResponse(response);
    }
}

