/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.command.library;

import io.github.interacto.command.CommandImpl;
import io.github.interacto.error.ErrorCatcher;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;

public class OpenWebPage
extends CommandImpl {
    protected URI uri;
    protected boolean browsed = false;

    @Override
    public void flush() {
        this.uri = null;
    }

    @Override
    protected void doCmdBody() {
        try {
            Desktop.getDesktop().browse(this.uri);
            this.browsed = true;
        }
        catch (IOException exception) {
            ErrorCatcher.getInstance().reportError(exception);
            this.browsed = false;
        }
    }

    @Override
    public boolean canDo() {
        return this.uri != null && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    @Override
    public boolean hadEffect() {
        return super.hadEffect() && this.browsed;
    }

    public void setUri(URI newURI) {
        this.uri = newURI;
    }
}

