/*
 * Decompiled with CFR 0.152.
 */
package io.github.interacto.command;

import io.github.interacto.command.Command;
import io.github.interacto.undo.UndoCollector;
import io.github.interacto.undo.Undoable;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;

public class CommandsRegistry {
    private static CommandsRegistry instance = new CommandsRegistry();
    private final List<Command> cmds = new ArrayList<Command>();
    private int sizeMax = 50;
    private final PublishSubject<Command> cmdPublisher = PublishSubject.create();

    public static CommandsRegistry getInstance() {
        return instance;
    }

    public static void setInstance(CommandsRegistry newInstance) {
        if (newInstance != null) {
            instance = newInstance;
        }
    }

    public Observable<Command> commands() {
        return this.cmdPublisher;
    }

    public List<Command> getCommands() {
        return this.cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCommand(Command cmd) {
        if (cmd == null) {
            return;
        }
        int i = 0;
        List<Command> list = this.cmds;
        synchronized (list) {
            while (i < this.cmds.size()) {
                if (this.cmds.get(i).unregisteredBy(cmd)) {
                    this.cmds.remove(i).flush();
                    continue;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command cmd) {
        List<Command> list = this.cmds;
        synchronized (list) {
            if (!(cmd == null || this.cmds.contains(cmd) || this.sizeMax <= 0 && cmd.getRegistrationPolicy() != Command.RegistrationPolicy.UNLIMITED)) {
                this.unregisterCommand(cmd);
                if (this.cmds.size() >= this.sizeMax) {
                    this.cmds.stream().filter(command -> command.getRegistrationPolicy() != Command.RegistrationPolicy.UNLIMITED).findFirst().ifPresent(command -> {
                        this.cmds.remove(command);
                        command.flush();
                    });
                }
                this.cmds.add(cmd);
                this.cmdPublisher.onNext((Object)cmd);
                if (cmd instanceof Undoable) {
                    UndoCollector.getInstance().add((Undoable)((Object)cmd));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command cmd) {
        if (cmd != null) {
            List<Command> list = this.cmds;
            synchronized (list) {
                this.cmds.remove(cmd);
            }
            cmd.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Command> list = this.cmds;
        synchronized (list) {
            this.cmds.forEach(cmd -> cmd.flush());
            this.cmds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCmd(Command cmd) {
        if (cmd != null) {
            cmd.cancel();
            List<Command> list = this.cmds;
            synchronized (list) {
                this.cmds.remove(cmd);
            }
            cmd.flush();
        }
    }

    public int getSizeMax() {
        return this.sizeMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSizeMax(int newSizeMax) {
        if (newSizeMax >= 0) {
            List<Command> list = this.cmds;
            synchronized (list) {
                int i = 0;
                int nb = 0;
                int toRemove = this.cmds.size() - newSizeMax;
                while (nb < toRemove && i < this.cmds.size()) {
                    if (this.cmds.get(i).getRegistrationPolicy() != Command.RegistrationPolicy.UNLIMITED) {
                        this.cmds.remove(i).flush();
                        ++nb;
                        continue;
                    }
                    ++i;
                }
            }
            this.sizeMax = newSizeMax;
        }
    }
}

