/*
 * Decompiled with CFR 0.152.
 */
package io.github.jycr.javadataurlhandler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class DataUriConnection
extends URLConnection {
    private static final Charset DEFAULT_CONTENT_CHARSET = StandardCharsets.US_ASCII;
    private static final String DEFAULT_MEDIATYPE = "text/plain";
    private final Charset charset;
    private final boolean isBase64;
    private final String data;
    private final String contentType;

    public DataUriConnection(URL url) throws MalformedURLException {
        super(url);
        String urlString = url.toString();
        if (!urlString.startsWith("data:")) {
            throw new MalformedURLException("Invalid data URL: " + url);
        }
        int commaIndex = urlString.indexOf(44);
        if (commaIndex == -1) {
            throw new MalformedURLException("Invalid data URL: " + url);
        }
        String metadata = urlString.substring(5, commaIndex);
        this.data = urlString.substring(commaIndex + 1);
        String[] parts = metadata.split(";");
        String mediatype = parts.length > 0 && !parts[0].isEmpty() ? parts[0] : DEFAULT_MEDIATYPE;
        boolean base64Flag = false;
        Charset extractedCharset = DEFAULT_CONTENT_CHARSET;
        for (String part : parts) {
            if ("base64".equals(part)) {
                base64Flag = true;
                continue;
            }
            if (!part.startsWith("charset=")) continue;
            extractedCharset = Charset.forName(part.substring(8));
        }
        this.isBase64 = base64Flag;
        this.charset = extractedCharset;
        this.contentType = mediatype + (String)(DataUriConnection.isText(mediatype) ? ";charset=" + this.charset.name() : "");
        this.connected = true;
    }

    private static boolean isText(String mediatype) {
        return mediatype != null && (mediatype.startsWith("text/") || mediatype.endsWith("+xml"));
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.getData());
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    private byte[] getData() {
        return this.isBase64 ? Base64.getDecoder().decode(this.data) : URLDecoder.decode(this.data, this.charset).getBytes(this.charset);
    }

    Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getHeaderField(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return String.valueOf(this.getData().length);
        }
        return null;
    }
}

