package io.github.kaststream.api;

import java.io.Serializable;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;

/**
 * @deprecated This class will be remove in next version
 *     <p>Use {@link io.github.kaststream.api.v2.Processor} The process function (engine low level
 *     operator)
 */
public interface Processor extends Serializable {

  /**
   * @param row in value
   * @param context the ProcessFunction.Context to eventually emit side-output streams
   * @param collector the out row collector
   * @throws Exception in case of problem. This will stop your stream.
   */
  public void processElement(
      final Row row,
      final ProcessFunction<Row, Row>.Context context,
      final Collector<Row> collector)
      throws Exception;

  /**
   * Declare the data type information of the data produced by your function.
   *
   * @param typeInfo the input row type information
   * @return the output row type information
   */
  public TypeInformation<Row> getProducedType(final TypeInformation<Row> typeInfo);

  /**
   * Declare the data type information of the sides out data produced by your function.
   *
   * @return the sides output type information
   */
  public default Map<String, TypeInformation<Row>> getSidesOutProducedType(
      final TypeInformation<Row> typeInfo) {
    return null;
  }

  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @param typeInfo the input row type information
   * @param runtimeContext Context that contains information about the UDF's runtime
   * @param sidesOutputTag Side output typeinfo and tag dict if any
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void open(
      final Configuration configuration,
      final TypeInformation<Row> typeInfo,
      final RuntimeContext runtimeContext,
      final Map<String, OutputTag<Row>> sidesOutputTag)
      throws Exception;

  /**
   * Tear-down method for the user code. It is called after the last call to the main working
   * methods. For functions that are part of an iteration, this method will be invoked after each
   * iteration superstep.
   *
   * <p>This method can be used for clean up work.
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void close() throws Exception;
}
