/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode.Http;

import chatimage.okhttp3.MediaType;
import chatimage.okhttp3.ResponseBody;
import chatimage.okio.Buffer;
import chatimage.okio.BufferedSource;
import chatimage.okio.ForwardingSource;
import chatimage.okio.Okio;
import chatimage.okio.Source;
import io.github.kituin.ChatImageCode.Http.IProgressListener;
import java.io.IOException;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final IProgressListener progressListener;
    private BufferedSource bufferedSource;

    public ProgressResponseBody(ResponseBody responseBody, IProgressListener progressListener) {
        this.responseBody = responseBody;
        this.progressListener = progressListener;
    }

    @Override
    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    @Override
    public long contentLength() {
        return this.responseBody.contentLength();
    }

    @Override
    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer(this.createSource(this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source createSource(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                ProgressResponseBody.this.progressListener.update(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength(), bytesRead == -1L);
                return bytesRead;
            }
        };
    }
}

