/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.entities.ex.Keyboard;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.http.data.V2MsgData;
import io.github.kloping.qqbot.http.data.V2Result;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Markdown
implements SendAble {
    private String custom_template_id;
    private List<Param> params = new LinkedList<Param>();
    private String content;
    @JSONField(serialize=false, deserialize=false)
    private Keyboard keyboard;

    public Markdown(String custom_template_id) {
        this.custom_template_id = custom_template_id;
    }

    public Markdown addParam(String key, String value) {
        this.params.add(new Param(key, new String[]{value}));
        return this;
    }

    public Markdown setContent(String content) {
        this.content = content;
        return this;
    }

    public Markdown setKeyboard(Keyboard keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    public Markdown setKeyboard(String id) {
        return this.setKeyboard(new Keyboard(id));
    }

    @Override
    public Result<V2Result> send(SenderAndCidMidGetter er) {
        return this.send(er, 1);
    }

    public Result<V2Result> send(SenderAndCidMidGetter er, Integer msgSeq) {
        if (er.getEnvType() == EnvType.GROUP) {
            V2MsgData v2MsgData = new V2MsgData();
            v2MsgData.setMarkdown(this);
            v2MsgData.setMsg_type(2);
            v2MsgData.setMsg_id(er.getMid());
            if (this.keyboard != null) {
                v2MsgData.setKeyboard(this.getKeyboard());
            }
            return new Result<V2Result>(er.getBot().groupBaseV2.send(er.getCid(), JSON.toJSONString((Object)v2MsgData), Channel.SEND_MESSAGE_HEADERS));
        }
        if (er.getEnvType() == EnvType.GUILD) {
            RawPreMessage preMessage = new RawPreMessage();
            preMessage.setMarkdown(this);
            preMessage.setMsgId(er.getMid());
            return new Result<ActionResult>(er.getBot().messageBase.send(er.getCid(), preMessage, Channel.SEND_MESSAGE_HEADERS));
        }
        return er.send(this);
    }

    public String getCustom_template_id() {
        return this.custom_template_id;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public String getContent() {
        return this.content;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public static class Param {
        public String key;
        private String[] values;

        public String getKey() {
            return this.key;
        }

        public String[] getValues() {
            return this.values;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValues(String[] values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Param)) {
                return false;
            }
            Param other = (Param)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            return Arrays.deepEquals(this.getValues(), other.getValues());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Param;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getValues());
            return result;
        }

        public String toString() {
            return "Markdown.Param(key=" + this.getKey() + ", values=" + Arrays.deepToString(this.getValues()) + ")";
        }

        public Param(String key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public Param() {
        }
    }
}

