/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.message.MessageDirectReceiveEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.qqpd.Guild;
import io.github.kloping.qqbot.entities.qqpd.Member;
import io.github.kloping.qqbot.entities.qqpd.message.DirectMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.impl.MessagePacket;
import io.github.kloping.qqbot.impl.message.BaseMessageReceiveEvent;

public class BaseMessageDirectReceiveEvent
extends BaseMessageReceiveEvent
implements MessageDirectReceiveEvent {
    private String srcGuildId;
    private Guild srcGuild;
    private DirectMessage directMessage;

    public BaseMessageDirectReceiveEvent(RawMessage message, JSONObject jo, Bot bot) {
        this.bot = bot;
        this.directMessage = DirectMessage.messageAsDirectMessage(message);
        this.message = this.directMessage;
        this.metadata = jo;
        this.srcGuildId = this.getRawMessage().getSrcGuildId();
        this.content = this.getRawMessage().getContent() == null ? "" : this.getRawMessage().getContent();
        this.srcGuild = this.getBot().getGuild(this.getSrcGuildId());
        this.guild = this.getBot().getGuild(this.getSrcGuildId());
        this.sender = this.getRawMessage().getMember();
    }

    @Override
    public Member getSender() {
        return super.getSender();
    }

    @Override
    public DirectMessage getDirectMessage() {
        return this.directMessage;
    }

    @Override
    public String getSrcGuildId() {
        return this.srcGuildId;
    }

    @Override
    public Guild getSrcGuild() {
        return this.srcGuild;
    }

    @Override
    public Result<ActionResult> send(String text) {
        return this.sendDirect(text);
    }

    @Override
    public Result<ActionResult> send(String text, RawMessage message) {
        return this.sendDirect(text, message);
    }

    @Override
    public Result<ActionResult> send(MessagePacket packet) {
        return this.sendDirect(packet);
    }

    @Override
    public Result<ActionResult> send(RawPreMessage msg) {
        return this.sendDirect(msg);
    }

    @Override
    public Result<ActionResult> sendDirect(String text) {
        return this.getDirectMessage().sendDirect(text);
    }

    @Override
    public Result<ActionResult> sendDirect(String text, RawMessage message) {
        return this.getDirectMessage().sendDirect(text, message);
    }

    @Override
    public Result<ActionResult> sendDirect(MessagePacket packet) {
        return this.getDirectMessage().sendDirect(packet);
    }

    @Override
    public Result<ActionResult> sendDirect(RawPreMessage msg) {
        return this.getDirectMessage().sendDirect(msg);
    }

    @Override
    public String toString() {
        return String.format("[channel(%s)]direct(%s)=>%s", this.getDirectMessage().getChannelId(), this.getSender().getNick(), this.getContent());
    }
}

