/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex;

import io.github.kloping.judge.Judge;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.api.SenderV2;
import io.github.kloping.qqbot.entities.ex.BaseKeyVals;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.http.data.V2MsgData;
import io.github.kloping.qqbot.http.data.V2Result;
import io.github.kloping.qqbot.impl.MessagePacket;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import org.jsoup.helper.HttpConnection;

public abstract class FileMsg
implements SendAble {
    private Integer file_type = 1;
    private String type;
    protected String url;
    protected byte[] bytes;
    protected String name;

    private FileMsg(FileType fileType) {
        this.file_type = fileType.value;
        switch (fileType) {
            case IMAGE: {
                this.type = "png";
                break;
            }
            case VIDEO: {
                this.type = "mp4";
                break;
            }
            case AUDIO: {
                this.type = "silk";
            }
        }
    }

    protected FileMsg(byte[] bytes, FileType fileType) {
        this(fileType);
        this.bytes = bytes;
    }

    protected FileMsg(String url, FileType fileType) {
        this(fileType);
        this.url = url;
    }

    public FileMsg(Integer file_type, String type2, String url, byte[] bytes, String name) {
        this.file_type = file_type;
        this.type = type2;
        this.url = url;
        this.bytes = bytes;
        this.name = name;
    }

    @Override
    public Result send(SenderAndCidMidGetter er) {
        if (er.getEnvType() == EnvType.GUILD) {
            if (this.getBytes() != null) {
                BaseKeyVals keyVals = new BaseKeyVals();
                if (er.getMid() != null) {
                    HttpConnection.KeyVal v0 = HttpConnection.KeyVal.create((String)"msg_id", (String)er.getMid());
                    v0.contentType("text/plain");
                    keyVals.add(v0);
                }
                HttpConnection.KeyVal v1 = HttpConnection.KeyVal.create((String)"file_image", (String)this.name);
                v1.inputStream((InputStream)new ByteArrayInputStream(this.bytes));
                v1.contentType(this.type);
                keyVals.add(v1);
                return new Result<ActionResult>(er.getBot().messageBase.send(er.getCid(), Channel.SEND_FORM_DATA_HEADERS, keyVals));
            }
            MessagePacket packet = new MessagePacket();
            if (Judge.isNotEmpty((String)this.getUrl())) {
                packet.setImage(this.getUrl());
            }
            return er.send(packet);
        }
        SenderV2 v2 = (SenderV2)((Object)er);
        RawMessage.filePrepare(this, er.getBot());
        V2Result result = null;
        result = Judge.isNotEmpty((String)this.getUrl()) ? v2.getV2().sendFile(er.getCid(), String.format("{\"file_type\": %s,\"url\": \"%s\",\"srv_send_msg\": false}", this.getFile_type(), this.getUrl()), Channel.SEND_MESSAGE_HEADERS) : v2.getV2().sendFile(er.getCid(), String.format("{\"file_type\": %s,\"file_data\": \"%s\",\"srv_send_msg\": false}", this.getFile_type(), Base64.getEncoder().encodeToString(this.bytes)), Channel.SEND_MESSAGE_HEADERS);
        result.logFileInfo(er.getBot().logger, this);
        V2MsgData data = new V2MsgData();
        data.setMsg_type(7);
        if (Judge.isNotEmpty((String)er.getMid())) {
            data.setMsg_id(er.getMid());
        }
        data.setMedia(new V2MsgData.Media(result.getFile_info()));
        data.setMsg_seq(v2.getMsgSeq());
        return new Result<V2Result>(v2.getV2().send(er.getCid(), data.toString(), Channel.SEND_MESSAGE_HEADERS));
    }

    public Integer getFile_type() {
        return this.file_type;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getName() {
        return this.name;
    }

    public FileMsg setType(String type2) {
        this.type = type2;
        return this;
    }

    public FileMsg setUrl(String url) {
        this.url = url;
        return this;
    }

    public FileMsg setBytes(byte[] bytes) {
        this.bytes = bytes;
        return this;
    }

    public FileMsg setName(String name) {
        this.name = name;
        return this;
    }

    public static enum FileType {
        IMAGE(1),
        VIDEO(2),
        AUDIO(3),
        FILE(4);

        final int value;

        private FileType(int value) {
            this.value = value;
        }
    }
}

