/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import io.github.larscom.websocket.BookPage;
import io.github.larscom.websocket.ImmutableBookPage;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Optional;

public class BookPageDeserializer
extends JsonDeserializer<BookPage> {
    public BookPage deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (!node.isArray() || node.size() != 2) {
            throw new JsonParseException(p, "Must be a 2-element array");
        }
        BigDecimal price = new BigDecimal(node.get(0).asText());
        String sizeStr = node.get(1).asText();
        Optional size = sizeStr.equals("0") ? Optional.empty() : Optional.of(new BigDecimal(sizeStr));
        return ImmutableBookPage.builder().price(price).size(size).build();
    }
}

