/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.larscom.websocket.ChannelName;
import io.github.larscom.websocket.ImmutableChannel;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableChannel.class)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableChannel.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE, overshadowImplementation=true)
public interface Channel {
    public ChannelName getName();

    public List<String> getMarkets();

    @JsonProperty(value="interval")
    public Optional<List<String>> getIntervals();

    @Value.Check
    default public void check() {
        if (this.getMarkets().isEmpty()) {
            throw new IllegalStateException("Cannot build Channel, some of the attributes are empty [markets]");
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableChannel.Builder {
    }
}

