/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.Book;
import io.github.larscom.websocket.BookPage;
import io.github.larscom.websocket.MessageIn;
import io.github.larscom.websocket.MessageInEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Book", generator="Immutables")
final class ImmutableBook
implements Book {
    private final MessageInEvent event;
    private final String market;
    private final int nonce;
    private final List<BookPage> bids;
    private final List<BookPage> asks;

    private ImmutableBook(MessageInEvent event, String market, int nonce, List<BookPage> bids, List<BookPage> asks) {
        this.event = event;
        this.market = market;
        this.nonce = nonce;
        this.bids = bids;
        this.asks = asks;
    }

    @Override
    @JsonProperty(value="event")
    public MessageInEvent getEvent() {
        return this.event;
    }

    @Override
    @JsonProperty(value="market")
    public String getMarket() {
        return this.market;
    }

    @Override
    @JsonProperty(value="nonce")
    public int getNonce() {
        return this.nonce;
    }

    @Override
    @JsonProperty(value="bids")
    public List<BookPage> getBids() {
        return this.bids;
    }

    @Override
    @JsonProperty(value="asks")
    public List<BookPage> getAsks() {
        return this.asks;
    }

    public final ImmutableBook withEvent(MessageInEvent value) {
        MessageInEvent newValue = Objects.requireNonNull(value, "event");
        if (this.event == newValue) {
            return this;
        }
        return new ImmutableBook(newValue, this.market, this.nonce, this.bids, this.asks);
    }

    public final ImmutableBook withMarket(String value) {
        String newValue = Objects.requireNonNull(value, "market");
        if (this.market.equals(newValue)) {
            return this;
        }
        return new ImmutableBook(this.event, newValue, this.nonce, this.bids, this.asks);
    }

    public final ImmutableBook withNonce(int value) {
        if (this.nonce == value) {
            return this;
        }
        return new ImmutableBook(this.event, this.market, value, this.bids, this.asks);
    }

    public final ImmutableBook withBids(BookPage ... elements) {
        List<BookPage> newValue = ImmutableBook.createUnmodifiableList(false, ImmutableBook.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBook(this.event, this.market, this.nonce, newValue, this.asks);
    }

    public final ImmutableBook withBids(Iterable<? extends BookPage> elements) {
        if (this.bids == elements) {
            return this;
        }
        List<BookPage> newValue = ImmutableBook.createUnmodifiableList(false, ImmutableBook.createSafeList(elements, true, false));
        return new ImmutableBook(this.event, this.market, this.nonce, newValue, this.asks);
    }

    public final ImmutableBook withAsks(BookPage ... elements) {
        List<BookPage> newValue = ImmutableBook.createUnmodifiableList(false, ImmutableBook.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBook(this.event, this.market, this.nonce, this.bids, newValue);
    }

    public final ImmutableBook withAsks(Iterable<? extends BookPage> elements) {
        if (this.asks == elements) {
            return this;
        }
        List<BookPage> newValue = ImmutableBook.createUnmodifiableList(false, ImmutableBook.createSafeList(elements, true, false));
        return new ImmutableBook(this.event, this.market, this.nonce, this.bids, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBook && this.equalTo(0, (ImmutableBook)another);
    }

    private boolean equalTo(int synthetic, ImmutableBook another) {
        return this.event.equals((Object)another.event) && this.market.equals(another.market) && this.nonce == another.nonce && this.bids.equals(another.bids) && this.asks.equals(another.asks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.event.hashCode();
        h += (h << 5) + this.market.hashCode();
        h += (h << 5) + this.nonce;
        h += (h << 5) + this.bids.hashCode();
        h += (h << 5) + this.asks.hashCode();
        return h;
    }

    public String toString() {
        return "Book{event=" + String.valueOf((Object)this.event) + ", market=" + this.market + ", nonce=" + this.nonce + ", bids=" + String.valueOf(this.bids) + ", asks=" + String.valueOf(this.asks) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBook fromJson(Json json) {
        Builder builder = ImmutableBook.builder();
        if (json.event != null) {
            builder.event(json.event);
        }
        if (json.market != null) {
            builder.market(json.market);
        }
        if (json.nonceIsSet) {
            builder.nonce(json.nonce);
        }
        if (json.bids != null) {
            builder.addAllBids(json.bids);
        }
        if (json.asks != null) {
            builder.addAllAsks(json.asks);
        }
        return (ImmutableBook)builder.build();
    }

    public static Book copyOf(Book instance) {
        if (instance instanceof ImmutableBook) {
            return (ImmutableBook)instance;
        }
        return ImmutableBook.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Book", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EVENT = 1L;
        private static final long INIT_BIT_MARKET = 2L;
        private static final long INIT_BIT_NONCE = 4L;
        private long initBits = 7L;
        private MessageInEvent event;
        private String market;
        private int nonce;
        private List<BookPage> bids = new ArrayList<BookPage>();
        private List<BookPage> asks = new ArrayList<BookPage>();

        private Builder() {
        }

        public final Builder from(Book instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageIn instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            MessageIn instance;
            long bits = 0L;
            if (object instanceof Book) {
                instance = (Book)object;
                this.market(instance.getMarket());
                this.addAllBids(instance.getBids());
                if ((bits & 1L) == 0L) {
                    this.event(instance.getEvent());
                    bits |= 1L;
                }
                this.nonce(instance.getNonce());
                this.addAllAsks(instance.getAsks());
            }
            if (object instanceof MessageIn) {
                instance = (MessageIn)object;
                if ((bits & 1L) == 0L) {
                    this.event(instance.getEvent());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="event")
        public final Builder event(MessageInEvent event) {
            this.event = Objects.requireNonNull(event, "event");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="market")
        public final Builder market(String market) {
            this.market = Objects.requireNonNull(market, "market");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="nonce")
        public final Builder nonce(int nonce) {
            this.nonce = nonce;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addBids(BookPage element) {
            this.bids.add(Objects.requireNonNull(element, "bids element"));
            return this;
        }

        public final Builder addBids(BookPage ... elements) {
            for (BookPage element : elements) {
                this.bids.add(Objects.requireNonNull(element, "bids element"));
            }
            return this;
        }

        @JsonProperty(value="bids")
        public final Builder bids(Iterable<? extends BookPage> elements) {
            this.bids.clear();
            return this.addAllBids(elements);
        }

        public final Builder addAllBids(Iterable<? extends BookPage> elements) {
            for (BookPage bookPage : elements) {
                this.bids.add(Objects.requireNonNull(bookPage, "bids element"));
            }
            return this;
        }

        public final Builder addAsks(BookPage element) {
            this.asks.add(Objects.requireNonNull(element, "asks element"));
            return this;
        }

        public final Builder addAsks(BookPage ... elements) {
            for (BookPage element : elements) {
                this.asks.add(Objects.requireNonNull(element, "asks element"));
            }
            return this;
        }

        @JsonProperty(value="asks")
        public final Builder asks(Iterable<? extends BookPage> elements) {
            this.asks.clear();
            return this.addAllAsks(elements);
        }

        public final Builder addAllAsks(Iterable<? extends BookPage> elements) {
            for (BookPage bookPage : elements) {
                this.asks.add(Objects.requireNonNull(bookPage, "asks element"));
            }
            return this;
        }

        public Book build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBook(this.event, this.market, this.nonce, ImmutableBook.createUnmodifiableList(true, this.bids), ImmutableBook.createUnmodifiableList(true, this.asks));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("event");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("market");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("nonce");
            }
            return "Cannot build Book, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Book", generator="Immutables")
    static final class Json
    implements Book {
        MessageInEvent event;
        String market;
        int nonce;
        boolean nonceIsSet;
        List<BookPage> bids = Collections.emptyList();
        List<BookPage> asks = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="event")
        public void setEvent(MessageInEvent event) {
            this.event = event;
        }

        @JsonProperty(value="market")
        public void setMarket(String market) {
            this.market = market;
        }

        @JsonProperty(value="nonce")
        public void setNonce(int nonce) {
            this.nonce = nonce;
            this.nonceIsSet = true;
        }

        @JsonProperty(value="bids")
        public void setBids(List<BookPage> bids) {
            this.bids = bids;
        }

        @JsonProperty(value="asks")
        public void setAsks(List<BookPage> asks) {
            this.asks = asks;
        }

        @Override
        public MessageInEvent getEvent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMarket() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getNonce() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BookPage> getBids() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BookPage> getAsks() {
            throw new UnsupportedOperationException();
        }
    }
}

