/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.BookPage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="BookPage", generator="Immutables")
final class ImmutableBookPage
implements BookPage {
    private final BigDecimal price;
    private final BigDecimal size;

    private ImmutableBookPage(BigDecimal price, BigDecimal size) {
        this.price = price;
        this.size = size;
    }

    @Override
    @JsonProperty(value="price")
    public BigDecimal getPrice() {
        return this.price;
    }

    @Override
    @JsonProperty(value="size")
    public Optional<BigDecimal> getSize() {
        return Optional.ofNullable(this.size);
    }

    public final ImmutableBookPage withPrice(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "price");
        if (this.price.equals(newValue)) {
            return this;
        }
        return new ImmutableBookPage(newValue, this.size);
    }

    public final ImmutableBookPage withSize(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "size");
        if (Objects.equals(this.size, newValue)) {
            return this;
        }
        return new ImmutableBookPage(this.price, newValue);
    }

    public final ImmutableBookPage withSize(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.size, value)) {
            return this;
        }
        return new ImmutableBookPage(this.price, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBookPage && this.equalTo(0, (ImmutableBookPage)another);
    }

    private boolean equalTo(int synthetic, ImmutableBookPage another) {
        return this.price.equals(another.price) && Objects.equals(this.size, another.size);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.price.hashCode();
        h += (h << 5) + Objects.hashCode(this.size);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BookPage{");
        builder.append("price=").append(this.price);
        if (this.size != null) {
            builder.append(", ");
            builder.append("size=").append(this.size);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBookPage fromJson(Json json) {
        Builder builder = ImmutableBookPage.builder();
        if (json.price != null) {
            builder.price(json.price);
        }
        if (json.size != null) {
            builder.size(json.size);
        }
        return (ImmutableBookPage)builder.build();
    }

    public static BookPage copyOf(BookPage instance) {
        if (instance instanceof ImmutableBookPage) {
            return (ImmutableBookPage)instance;
        }
        return ImmutableBookPage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookPage", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PRICE = 1L;
        private long initBits = 1L;
        private BigDecimal price;
        private BigDecimal size;

        private Builder() {
        }

        public final Builder from(BookPage instance) {
            Objects.requireNonNull(instance, "instance");
            this.price(instance.getPrice());
            Optional<BigDecimal> sizeOptional = instance.getSize();
            if (sizeOptional.isPresent()) {
                this.size(sizeOptional);
            }
            return this;
        }

        @JsonProperty(value="price")
        public final Builder price(BigDecimal price) {
            this.price = Objects.requireNonNull(price, "price");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder size(BigDecimal size) {
            this.size = Objects.requireNonNull(size, "size");
            return this;
        }

        @JsonProperty(value="size")
        public final Builder size(Optional<? extends BigDecimal> size) {
            this.size = size.orElse(null);
            return this;
        }

        public BookPage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBookPage(this.price, this.size);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("price");
            }
            return "Cannot build BookPage, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookPage", generator="Immutables")
    static final class Json
    implements BookPage {
        BigDecimal price;
        Optional<BigDecimal> size = Optional.empty();

        Json() {
        }

        @JsonProperty(value="price")
        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        @JsonProperty(value="size")
        public void setSize(Optional<BigDecimal> size) {
            this.size = size;
        }

        @Override
        public BigDecimal getPrice() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> getSize() {
            throw new UnsupportedOperationException();
        }
    }
}

