/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.Channel;
import io.github.larscom.websocket.ChannelName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Channel", generator="Immutables")
final class ImmutableChannel
implements Channel {
    private final ChannelName name;
    private final List<String> markets;
    private final List<String> intervals;

    private ImmutableChannel(ChannelName name, List<String> markets, List<String> intervals) {
        this.name = name;
        this.markets = markets;
        this.intervals = intervals;
    }

    @Override
    @JsonProperty(value="name")
    public ChannelName getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="markets")
    public List<String> getMarkets() {
        return this.markets;
    }

    @Override
    @JsonProperty(value="interval")
    public Optional<List<String>> getIntervals() {
        return Optional.ofNullable(this.intervals);
    }

    public final ImmutableChannel withName(ChannelName value) {
        ChannelName newValue = Objects.requireNonNull(value, "name");
        if (this.name == newValue) {
            return this;
        }
        return ImmutableChannel.validate(new ImmutableChannel(newValue, this.markets, this.intervals));
    }

    public final ImmutableChannel withMarkets(String ... elements) {
        List<String> newValue = ImmutableChannel.createUnmodifiableList(false, ImmutableChannel.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableChannel.validate(new ImmutableChannel(this.name, newValue, this.intervals));
    }

    public final ImmutableChannel withMarkets(Iterable<String> elements) {
        if (this.markets == elements) {
            return this;
        }
        List<String> newValue = ImmutableChannel.createUnmodifiableList(false, ImmutableChannel.createSafeList(elements, true, false));
        return ImmutableChannel.validate(new ImmutableChannel(this.name, newValue, this.intervals));
    }

    public final ImmutableChannel withIntervals(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "intervals");
        if (this.intervals == newValue) {
            return this;
        }
        return ImmutableChannel.validate(new ImmutableChannel(this.name, this.markets, newValue));
    }

    public final ImmutableChannel withIntervals(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.intervals == value) {
            return this;
        }
        return ImmutableChannel.validate(new ImmutableChannel(this.name, this.markets, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannel && this.equalTo(0, (ImmutableChannel)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannel another) {
        return this.name.equals((Object)another.name) && this.markets.equals(another.markets) && Objects.equals(this.intervals, another.intervals);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.markets.hashCode();
        h += (h << 5) + Objects.hashCode(this.intervals);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Channel{");
        builder.append("name=").append((Object)this.name);
        builder.append(", ");
        builder.append("markets=").append(this.markets);
        if (this.intervals != null) {
            builder.append(", ");
            builder.append("intervals=").append(this.intervals);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChannel fromJson(Json json) {
        Channel.Builder builder = new Channel.Builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.markets != null) {
            builder.addAllMarkets(json.markets);
        }
        if (json.intervals != null) {
            builder.intervals(json.intervals);
        }
        return (ImmutableChannel)builder.build();
    }

    private static ImmutableChannel validate(ImmutableChannel instance) {
        instance.check();
        return instance;
    }

    public static Channel copyOf(Channel instance) {
        if (instance instanceof ImmutableChannel) {
            return (ImmutableChannel)instance;
        }
        return new Channel.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Channel", generator="Immutables")
    static final class Json
    implements Channel {
        ChannelName name;
        List<String> markets = Collections.emptyList();
        Optional<List<String>> intervals = Optional.empty();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(ChannelName name) {
            this.name = name;
        }

        @JsonProperty(value="markets")
        public void setMarkets(List<String> markets) {
            this.markets = markets;
        }

        @JsonProperty(value="interval")
        public void setIntervals(Optional<List<String>> intervals) {
            this.intervals = intervals;
        }

        @Override
        public ChannelName getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getMarkets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getIntervals() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="Channel", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private ChannelName name;
        private List<String> markets = new ArrayList<String>();
        private List<String> intervals;

        public Builder() {
            if (!(this instanceof Channel.Builder)) {
                throw new UnsupportedOperationException("Use: new Channel.Builder()");
            }
        }

        public final Channel.Builder from(Channel instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.addAllMarkets(instance.getMarkets());
            Optional<List<String>> intervalsOptional = instance.getIntervals();
            if (intervalsOptional.isPresent()) {
                this.intervals(intervalsOptional);
            }
            return (Channel.Builder)this;
        }

        @JsonProperty(value="name")
        public final Channel.Builder name(ChannelName name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Channel.Builder)this;
        }

        public final Channel.Builder addMarkets(String element) {
            this.markets.add(Objects.requireNonNull(element, "markets element"));
            return (Channel.Builder)this;
        }

        public final Channel.Builder addMarkets(String ... elements) {
            for (String element : elements) {
                this.markets.add(Objects.requireNonNull(element, "markets element"));
            }
            return (Channel.Builder)this;
        }

        @JsonProperty(value="markets")
        public final Channel.Builder markets(Iterable<String> elements) {
            this.markets.clear();
            return this.addAllMarkets(elements);
        }

        public final Channel.Builder addAllMarkets(Iterable<String> elements) {
            for (String element : elements) {
                this.markets.add(Objects.requireNonNull(element, "markets element"));
            }
            return (Channel.Builder)this;
        }

        public final Channel.Builder intervals(List<String> intervals) {
            this.intervals = Objects.requireNonNull(intervals, "intervals");
            return (Channel.Builder)this;
        }

        @JsonProperty(value="interval")
        public final Channel.Builder intervals(Optional<? extends List<String>> intervals) {
            this.intervals = intervals.orElse(null);
            return (Channel.Builder)this;
        }

        public Channel build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableChannel.validate(new ImmutableChannel(this.name, ImmutableChannel.createUnmodifiableList(true, this.markets), this.intervals));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Channel, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

