/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.Error;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Error", generator="Immutables")
final class ImmutableError
implements Error {
    private final int errorCode;
    private final String errorMessage;
    private final String action;

    private ImmutableError(int errorCode, String errorMessage, String action) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.action = action;
    }

    @Override
    @JsonProperty(value="errorCode")
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="error")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="action")
    public Optional<String> getAction() {
        return Optional.ofNullable(this.action);
    }

    public final ImmutableError withErrorCode(int value) {
        if (this.errorCode == value) {
            return this;
        }
        return new ImmutableError(value, this.errorMessage, this.action);
    }

    public final ImmutableError withErrorMessage(String value) {
        String newValue = Objects.requireNonNull(value, "errorMessage");
        if (this.errorMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableError(this.errorCode, newValue, this.action);
    }

    public final ImmutableError withAction(String value) {
        String newValue = Objects.requireNonNull(value, "action");
        if (Objects.equals(this.action, newValue)) {
            return this;
        }
        return new ImmutableError(this.errorCode, this.errorMessage, newValue);
    }

    public final ImmutableError withAction(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.action, value)) {
            return this;
        }
        return new ImmutableError(this.errorCode, this.errorMessage, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableError && this.equalTo(0, (ImmutableError)another);
    }

    private boolean equalTo(int synthetic, ImmutableError another) {
        return this.errorCode == another.errorCode && this.errorMessage.equals(another.errorMessage) && Objects.equals(this.action, another.action);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.errorCode;
        h += (h << 5) + this.errorMessage.hashCode();
        h += (h << 5) + Objects.hashCode(this.action);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Error{");
        builder.append("errorCode=").append(this.errorCode);
        builder.append(", ");
        builder.append("errorMessage=").append(this.errorMessage);
        if (this.action != null) {
            builder.append(", ");
            builder.append("action=").append(this.action);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableError fromJson(Json json) {
        Error.Builder builder = new Error.Builder();
        if (json.errorCodeIsSet) {
            builder.errorCode(json.errorCode);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.action != null) {
            builder.action(json.action);
        }
        return (ImmutableError)builder.build();
    }

    public static Error copyOf(Error instance) {
        if (instance instanceof ImmutableError) {
            return (ImmutableError)instance;
        }
        return new Error.Builder().from(instance).build();
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Error", generator="Immutables")
    static final class Json
    implements Error {
        int errorCode;
        boolean errorCodeIsSet;
        String errorMessage;
        Optional<String> action = Optional.empty();

        Json() {
        }

        @JsonProperty(value="errorCode")
        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
            this.errorCodeIsSet = true;
        }

        @JsonProperty(value="error")
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="action")
        public void setAction(Optional<String> action) {
            this.action = action;
        }

        @Override
        public int getErrorCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAction() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="Error", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_ERROR_CODE = 1L;
        private static final long INIT_BIT_ERROR_MESSAGE = 2L;
        private long initBits = 3L;
        private int errorCode;
        private String errorMessage;
        private String action;

        public Builder() {
            if (!(this instanceof Error.Builder)) {
                throw new UnsupportedOperationException("Use: new Error.Builder()");
            }
        }

        public final Error.Builder from(Error instance) {
            Objects.requireNonNull(instance, "instance");
            this.errorCode(instance.getErrorCode());
            this.errorMessage(instance.getErrorMessage());
            Optional<String> actionOptional = instance.getAction();
            if (actionOptional.isPresent()) {
                this.action(actionOptional);
            }
            return (Error.Builder)this;
        }

        @JsonProperty(value="errorCode")
        public final Error.Builder errorCode(int errorCode) {
            this.errorCode = errorCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Error.Builder)this;
        }

        @JsonProperty(value="error")
        public final Error.Builder errorMessage(String errorMessage) {
            this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Error.Builder)this;
        }

        public final Error.Builder action(String action) {
            this.action = Objects.requireNonNull(action, "action");
            return (Error.Builder)this;
        }

        @JsonProperty(value="action")
        public final Error.Builder action(Optional<String> action) {
            this.action = action.orElse(null);
            return (Error.Builder)this;
        }

        public Error build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableError(this.errorCode, this.errorMessage, this.action);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("errorCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorMessage");
            }
            return "Cannot build Error, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

