/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.Action;
import io.github.larscom.websocket.Channel;
import io.github.larscom.websocket.MessageOut;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="MessageOut", generator="Immutables")
final class ImmutableMessageOut
implements MessageOut {
    private final Action action;
    private final List<Channel> channels;
    private final String key;
    private final String signature;
    private final Long timestamp;

    private ImmutableMessageOut(Action action, List<Channel> channels, String key, String signature, Long timestamp) {
        this.action = action;
        this.channels = channels;
        this.key = key;
        this.signature = signature;
        this.timestamp = timestamp;
    }

    @Override
    @JsonProperty(value="action")
    public Action getAction() {
        return this.action;
    }

    @Override
    @JsonProperty(value="channels")
    public Optional<List<Channel>> getChannels() {
        return Optional.ofNullable(this.channels);
    }

    @Override
    @JsonProperty(value="key")
    public Optional<String> getKey() {
        return Optional.ofNullable(this.key);
    }

    @Override
    @JsonProperty(value="signature")
    public Optional<String> getSignature() {
        return Optional.ofNullable(this.signature);
    }

    @Override
    @JsonProperty(value="timestamp")
    public Optional<Long> getTimestamp() {
        return Optional.ofNullable(this.timestamp);
    }

    public final ImmutableMessageOut withAction(Action value) {
        Action newValue = Objects.requireNonNull(value, "action");
        if (this.action == newValue) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(newValue, this.channels, this.key, this.signature, this.timestamp));
    }

    public final ImmutableMessageOut withChannels(List<Channel> value) {
        List<Channel> newValue = Objects.requireNonNull(value, "channels");
        if (this.channels == newValue) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, newValue, this.key, this.signature, this.timestamp));
    }

    public final ImmutableMessageOut withChannels(Optional<? extends List<Channel>> optional) {
        List value = optional.orElse(null);
        if (this.channels == value) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, value, this.key, this.signature, this.timestamp));
    }

    public final ImmutableMessageOut withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (Objects.equals(this.key, newValue)) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, newValue, this.signature, this.timestamp));
    }

    public final ImmutableMessageOut withKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.key, value)) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, value, this.signature, this.timestamp));
    }

    public final ImmutableMessageOut withSignature(String value) {
        String newValue = Objects.requireNonNull(value, "signature");
        if (Objects.equals(this.signature, newValue)) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, this.key, newValue, this.timestamp));
    }

    public final ImmutableMessageOut withSignature(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.signature, value)) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, this.key, value, this.timestamp));
    }

    public final ImmutableMessageOut withTimestamp(long value) {
        Long newValue = value;
        if (Objects.equals(this.timestamp, newValue)) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, this.key, this.signature, newValue));
    }

    public final ImmutableMessageOut withTimestamp(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.timestamp, value)) {
            return this;
        }
        return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, this.key, this.signature, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageOut && this.equalTo(0, (ImmutableMessageOut)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageOut another) {
        return this.action.equals((Object)another.action) && Objects.equals(this.channels, another.channels) && Objects.equals(this.key, another.key) && Objects.equals(this.signature, another.signature) && Objects.equals(this.timestamp, another.timestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + Objects.hashCode(this.channels);
        h += (h << 5) + Objects.hashCode(this.key);
        h += (h << 5) + Objects.hashCode(this.signature);
        h += (h << 5) + Objects.hashCode(this.timestamp);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MessageOut{");
        builder.append("action=").append((Object)this.action);
        if (this.channels != null) {
            builder.append(", ");
            builder.append("channels=").append(this.channels);
        }
        if (this.key != null) {
            builder.append(", ");
            builder.append("key=").append(this.key);
        }
        if (this.signature != null) {
            builder.append(", ");
            builder.append("signature=").append(this.signature);
        }
        if (this.timestamp != null) {
            builder.append(", ");
            builder.append("timestamp=").append(this.timestamp);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageOut fromJson(Json json) {
        MessageOut.Builder builder = new MessageOut.Builder();
        if (json.action != null) {
            builder.action(json.action);
        }
        if (json.channels != null) {
            builder.channels(json.channels);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.signature != null) {
            builder.signature(json.signature);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        return (ImmutableMessageOut)builder.build();
    }

    private static ImmutableMessageOut validate(ImmutableMessageOut instance) {
        instance.check();
        return instance;
    }

    public static MessageOut copyOf(MessageOut instance) {
        if (instance instanceof ImmutableMessageOut) {
            return (ImmutableMessageOut)instance;
        }
        return new MessageOut.Builder().from(instance).build();
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageOut", generator="Immutables")
    static final class Json
    implements MessageOut {
        Action action;
        Optional<List<Channel>> channels = Optional.empty();
        Optional<String> key = Optional.empty();
        Optional<String> signature = Optional.empty();
        Optional<Long> timestamp = Optional.empty();

        Json() {
        }

        @JsonProperty(value="action")
        public void setAction(Action action) {
            this.action = action;
        }

        @JsonProperty(value="channels")
        public void setChannels(Optional<List<Channel>> channels) {
            this.channels = channels;
        }

        @JsonProperty(value="key")
        public void setKey(Optional<String> key) {
            this.key = key;
        }

        @JsonProperty(value="signature")
        public void setSignature(Optional<String> signature) {
            this.signature = signature;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(Optional<Long> timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Action getAction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Channel>> getChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSignature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getTimestamp() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MessageOut", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_ACTION = 1L;
        private long initBits = 1L;
        private Action action;
        private List<Channel> channels;
        private String key;
        private String signature;
        private Long timestamp;

        public Builder() {
            if (!(this instanceof MessageOut.Builder)) {
                throw new UnsupportedOperationException("Use: new MessageOut.Builder()");
            }
        }

        public final MessageOut.Builder from(MessageOut instance) {
            Optional<Long> timestampOptional;
            Optional<String> signatureOptional;
            Optional<String> keyOptional;
            Objects.requireNonNull(instance, "instance");
            this.action(instance.getAction());
            Optional<List<Channel>> channelsOptional = instance.getChannels();
            if (channelsOptional.isPresent()) {
                this.channels(channelsOptional);
            }
            if ((keyOptional = instance.getKey()).isPresent()) {
                this.key(keyOptional);
            }
            if ((signatureOptional = instance.getSignature()).isPresent()) {
                this.signature(signatureOptional);
            }
            if ((timestampOptional = instance.getTimestamp()).isPresent()) {
                this.timestamp(timestampOptional);
            }
            return (MessageOut.Builder)this;
        }

        @JsonProperty(value="action")
        public final MessageOut.Builder action(Action action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (MessageOut.Builder)this;
        }

        public final MessageOut.Builder channels(List<Channel> channels) {
            this.channels = Objects.requireNonNull(channels, "channels");
            return (MessageOut.Builder)this;
        }

        @JsonProperty(value="channels")
        public final MessageOut.Builder channels(Optional<? extends List<Channel>> channels) {
            this.channels = channels.orElse(null);
            return (MessageOut.Builder)this;
        }

        public final MessageOut.Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            return (MessageOut.Builder)this;
        }

        @JsonProperty(value="key")
        public final MessageOut.Builder key(Optional<String> key) {
            this.key = key.orElse(null);
            return (MessageOut.Builder)this;
        }

        public final MessageOut.Builder signature(String signature) {
            this.signature = Objects.requireNonNull(signature, "signature");
            return (MessageOut.Builder)this;
        }

        @JsonProperty(value="signature")
        public final MessageOut.Builder signature(Optional<String> signature) {
            this.signature = signature.orElse(null);
            return (MessageOut.Builder)this;
        }

        public final MessageOut.Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return (MessageOut.Builder)this;
        }

        @JsonProperty(value="timestamp")
        public final MessageOut.Builder timestamp(Optional<Long> timestamp) {
            this.timestamp = timestamp.orElse(null);
            return (MessageOut.Builder)this;
        }

        public MessageOut build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableMessageOut.validate(new ImmutableMessageOut(this.action, this.channels, this.key, this.signature, this.timestamp));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("action");
            }
            return "Cannot build MessageOut, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

