/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.ChannelName;
import io.github.larscom.websocket.MessageIn;
import io.github.larscom.websocket.MessageInEvent;
import io.github.larscom.websocket.Subscription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Subscription", generator="Immutables")
final class ImmutableSubscription
implements Subscription {
    private final MessageInEvent event;
    private final HashMap<ChannelName, List<String>> activeSubscriptions;

    private ImmutableSubscription(MessageInEvent event, HashMap<ChannelName, List<String>> activeSubscriptions) {
        this.event = event;
        this.activeSubscriptions = activeSubscriptions;
    }

    @Override
    @JsonProperty(value="event")
    public MessageInEvent getEvent() {
        return this.event;
    }

    @Override
    @JsonProperty(value="subscriptions")
    public HashMap<ChannelName, List<String>> getActiveSubscriptions() {
        return this.activeSubscriptions;
    }

    public final ImmutableSubscription withEvent(MessageInEvent value) {
        MessageInEvent newValue = Objects.requireNonNull(value, "event");
        if (this.event == newValue) {
            return this;
        }
        return new ImmutableSubscription(newValue, this.activeSubscriptions);
    }

    public final ImmutableSubscription withActiveSubscriptions(HashMap<ChannelName, List<String>> value) {
        if (this.activeSubscriptions == value) {
            return this;
        }
        HashMap<ChannelName, List<String>> newValue = Objects.requireNonNull(value, "activeSubscriptions");
        return new ImmutableSubscription(this.event, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubscription && this.equalTo(0, (ImmutableSubscription)another);
    }

    private boolean equalTo(int synthetic, ImmutableSubscription another) {
        return this.event.equals((Object)another.event) && this.activeSubscriptions.equals(another.activeSubscriptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.event.hashCode();
        h += (h << 5) + this.activeSubscriptions.hashCode();
        return h;
    }

    public String toString() {
        return "Subscription{event=" + String.valueOf((Object)this.event) + ", activeSubscriptions=" + String.valueOf(this.activeSubscriptions) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSubscription fromJson(Json json) {
        Builder builder = ImmutableSubscription.builder();
        if (json.event != null) {
            builder.event(json.event);
        }
        if (json.activeSubscriptions != null) {
            builder.activeSubscriptions(json.activeSubscriptions);
        }
        return (ImmutableSubscription)builder.build();
    }

    public static Subscription copyOf(Subscription instance) {
        if (instance instanceof ImmutableSubscription) {
            return (ImmutableSubscription)instance;
        }
        return ImmutableSubscription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Subscription", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EVENT = 1L;
        private static final long INIT_BIT_ACTIVE_SUBSCRIPTIONS = 2L;
        private long initBits = 3L;
        private MessageInEvent event;
        private HashMap<ChannelName, List<String>> activeSubscriptions;

        private Builder() {
        }

        public final Builder from(MessageIn instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Subscription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            MessageIn instance;
            long bits = 0L;
            if (object instanceof MessageIn) {
                instance = (MessageIn)object;
                if ((bits & 1L) == 0L) {
                    this.event(instance.getEvent());
                    bits |= 1L;
                }
            }
            if (object instanceof Subscription) {
                instance = (Subscription)object;
                if ((bits & 1L) == 0L) {
                    this.event(instance.getEvent());
                    bits |= 1L;
                }
                this.activeSubscriptions(instance.getActiveSubscriptions());
            }
        }

        @JsonProperty(value="event")
        public final Builder event(MessageInEvent event) {
            this.event = Objects.requireNonNull(event, "event");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="subscriptions")
        public final Builder activeSubscriptions(HashMap<ChannelName, List<String>> activeSubscriptions) {
            this.activeSubscriptions = Objects.requireNonNull(activeSubscriptions, "activeSubscriptions");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Subscription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubscription(this.event, this.activeSubscriptions);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("event");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("activeSubscriptions");
            }
            return "Cannot build Subscription, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Subscription", generator="Immutables")
    static final class Json
    implements Subscription {
        MessageInEvent event;
        HashMap<ChannelName, List<String>> activeSubscriptions;

        Json() {
        }

        @JsonProperty(value="event")
        public void setEvent(MessageInEvent event) {
            this.event = event;
        }

        @JsonProperty(value="subscriptions")
        public void setActiveSubscriptions(HashMap<ChannelName, List<String>> activeSubscriptions) {
            this.activeSubscriptions = activeSubscriptions;
        }

        @Override
        public MessageInEvent getEvent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HashMap<ChannelName, List<String>> getActiveSubscriptions() {
            throw new UnsupportedOperationException();
        }
    }
}

