/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.larscom.websocket.MessageIn;
import io.github.larscom.websocket.MessageInEvent;
import io.github.larscom.websocket.Ticker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Ticker", generator="Immutables")
final class ImmutableTicker
implements Ticker {
    private final MessageInEvent event;
    private final String market;
    private final BigDecimal bestBid;
    private final BigDecimal bestBidSize;
    private final BigDecimal bestAsk;
    private final BigDecimal bestAskSize;
    private final BigDecimal lastPrice;

    private ImmutableTicker(MessageInEvent event, String market, BigDecimal bestBid, BigDecimal bestBidSize, BigDecimal bestAsk, BigDecimal bestAskSize, BigDecimal lastPrice) {
        this.event = event;
        this.market = market;
        this.bestBid = bestBid;
        this.bestBidSize = bestBidSize;
        this.bestAsk = bestAsk;
        this.bestAskSize = bestAskSize;
        this.lastPrice = lastPrice;
    }

    @Override
    @JsonProperty(value="event")
    public MessageInEvent getEvent() {
        return this.event;
    }

    @Override
    @JsonProperty(value="market")
    public String getMarket() {
        return this.market;
    }

    @Override
    @JsonProperty(value="bestBid")
    public Optional<BigDecimal> getBestBid() {
        return Optional.ofNullable(this.bestBid);
    }

    @Override
    @JsonProperty(value="bestBidSize")
    public Optional<BigDecimal> getBestBidSize() {
        return Optional.ofNullable(this.bestBidSize);
    }

    @Override
    @JsonProperty(value="bestAsk")
    public Optional<BigDecimal> getBestAsk() {
        return Optional.ofNullable(this.bestAsk);
    }

    @Override
    @JsonProperty(value="bestAskSize")
    public Optional<BigDecimal> getBestAskSize() {
        return Optional.ofNullable(this.bestAskSize);
    }

    @Override
    @JsonProperty(value="lastPrice")
    public Optional<BigDecimal> getLastPrice() {
        return Optional.ofNullable(this.lastPrice);
    }

    public final ImmutableTicker withEvent(MessageInEvent value) {
        MessageInEvent newValue = Objects.requireNonNull(value, "event");
        if (this.event == newValue) {
            return this;
        }
        return new ImmutableTicker(newValue, this.market, this.bestBid, this.bestBidSize, this.bestAsk, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withMarket(String value) {
        String newValue = Objects.requireNonNull(value, "market");
        if (this.market.equals(newValue)) {
            return this;
        }
        return new ImmutableTicker(this.event, newValue, this.bestBid, this.bestBidSize, this.bestAsk, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestBid(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "bestBid");
        if (Objects.equals(this.bestBid, newValue)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, newValue, this.bestBidSize, this.bestAsk, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestBid(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.bestBid, value)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, value, this.bestBidSize, this.bestAsk, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestBidSize(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "bestBidSize");
        if (Objects.equals(this.bestBidSize, newValue)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, newValue, this.bestAsk, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestBidSize(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.bestBidSize, value)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, value, this.bestAsk, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestAsk(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "bestAsk");
        if (Objects.equals(this.bestAsk, newValue)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, newValue, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestAsk(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.bestAsk, value)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, value, this.bestAskSize, this.lastPrice);
    }

    public final ImmutableTicker withBestAskSize(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "bestAskSize");
        if (Objects.equals(this.bestAskSize, newValue)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, this.bestAsk, newValue, this.lastPrice);
    }

    public final ImmutableTicker withBestAskSize(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.bestAskSize, value)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, this.bestAsk, value, this.lastPrice);
    }

    public final ImmutableTicker withLastPrice(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "lastPrice");
        if (Objects.equals(this.lastPrice, newValue)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, this.bestAsk, this.bestAskSize, newValue);
    }

    public final ImmutableTicker withLastPrice(Optional<? extends BigDecimal> optional) {
        BigDecimal value = optional.orElse(null);
        if (Objects.equals(this.lastPrice, value)) {
            return this;
        }
        return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, this.bestAsk, this.bestAskSize, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTicker && this.equalTo(0, (ImmutableTicker)another);
    }

    private boolean equalTo(int synthetic, ImmutableTicker another) {
        return this.event.equals((Object)another.event) && this.market.equals(another.market) && Objects.equals(this.bestBid, another.bestBid) && Objects.equals(this.bestBidSize, another.bestBidSize) && Objects.equals(this.bestAsk, another.bestAsk) && Objects.equals(this.bestAskSize, another.bestAskSize) && Objects.equals(this.lastPrice, another.lastPrice);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.event.hashCode();
        h += (h << 5) + this.market.hashCode();
        h += (h << 5) + Objects.hashCode(this.bestBid);
        h += (h << 5) + Objects.hashCode(this.bestBidSize);
        h += (h << 5) + Objects.hashCode(this.bestAsk);
        h += (h << 5) + Objects.hashCode(this.bestAskSize);
        h += (h << 5) + Objects.hashCode(this.lastPrice);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Ticker{");
        builder.append("event=").append((Object)this.event);
        builder.append(", ");
        builder.append("market=").append(this.market);
        if (this.bestBid != null) {
            builder.append(", ");
            builder.append("bestBid=").append(this.bestBid);
        }
        if (this.bestBidSize != null) {
            builder.append(", ");
            builder.append("bestBidSize=").append(this.bestBidSize);
        }
        if (this.bestAsk != null) {
            builder.append(", ");
            builder.append("bestAsk=").append(this.bestAsk);
        }
        if (this.bestAskSize != null) {
            builder.append(", ");
            builder.append("bestAskSize=").append(this.bestAskSize);
        }
        if (this.lastPrice != null) {
            builder.append(", ");
            builder.append("lastPrice=").append(this.lastPrice);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTicker fromJson(Json json) {
        Builder builder = ImmutableTicker.builder();
        if (json.event != null) {
            builder.event(json.event);
        }
        if (json.market != null) {
            builder.market(json.market);
        }
        if (json.bestBid != null) {
            builder.bestBid(json.bestBid);
        }
        if (json.bestBidSize != null) {
            builder.bestBidSize(json.bestBidSize);
        }
        if (json.bestAsk != null) {
            builder.bestAsk(json.bestAsk);
        }
        if (json.bestAskSize != null) {
            builder.bestAskSize(json.bestAskSize);
        }
        if (json.lastPrice != null) {
            builder.lastPrice(json.lastPrice);
        }
        return (ImmutableTicker)builder.build();
    }

    public static Ticker copyOf(Ticker instance) {
        if (instance instanceof ImmutableTicker) {
            return (ImmutableTicker)instance;
        }
        return ImmutableTicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Ticker", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EVENT = 1L;
        private static final long INIT_BIT_MARKET = 2L;
        private long initBits = 3L;
        private MessageInEvent event;
        private String market;
        private BigDecimal bestBid;
        private BigDecimal bestBidSize;
        private BigDecimal bestAsk;
        private BigDecimal bestAskSize;
        private BigDecimal lastPrice;

        private Builder() {
        }

        public final Builder from(Ticker instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageIn instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            MessageIn instance;
            long bits = 0L;
            if (object instanceof Ticker) {
                Optional<BigDecimal> lastPriceOptional;
                Optional<BigDecimal> bestAskSizeOptional;
                Optional<BigDecimal> bestBidOptional;
                Optional<BigDecimal> bestBidSizeOptional;
                instance = (Ticker)object;
                this.market(instance.getMarket());
                Optional<BigDecimal> bestAskOptional = instance.getBestAsk();
                if (bestAskOptional.isPresent()) {
                    this.bestAsk(bestAskOptional);
                }
                if ((bestBidSizeOptional = instance.getBestBidSize()).isPresent()) {
                    this.bestBidSize(bestBidSizeOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.event(instance.getEvent());
                    bits |= 1L;
                }
                if ((bestBidOptional = instance.getBestBid()).isPresent()) {
                    this.bestBid(bestBidOptional);
                }
                if ((bestAskSizeOptional = instance.getBestAskSize()).isPresent()) {
                    this.bestAskSize(bestAskSizeOptional);
                }
                if ((lastPriceOptional = instance.getLastPrice()).isPresent()) {
                    this.lastPrice(lastPriceOptional);
                }
            }
            if (object instanceof MessageIn) {
                instance = (MessageIn)object;
                if ((bits & 1L) == 0L) {
                    this.event(instance.getEvent());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="event")
        public final Builder event(MessageInEvent event) {
            this.event = Objects.requireNonNull(event, "event");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="market")
        public final Builder market(String market) {
            this.market = Objects.requireNonNull(market, "market");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bestBid(BigDecimal bestBid) {
            this.bestBid = Objects.requireNonNull(bestBid, "bestBid");
            return this;
        }

        @JsonProperty(value="bestBid")
        public final Builder bestBid(Optional<? extends BigDecimal> bestBid) {
            this.bestBid = bestBid.orElse(null);
            return this;
        }

        public final Builder bestBidSize(BigDecimal bestBidSize) {
            this.bestBidSize = Objects.requireNonNull(bestBidSize, "bestBidSize");
            return this;
        }

        @JsonProperty(value="bestBidSize")
        public final Builder bestBidSize(Optional<? extends BigDecimal> bestBidSize) {
            this.bestBidSize = bestBidSize.orElse(null);
            return this;
        }

        public final Builder bestAsk(BigDecimal bestAsk) {
            this.bestAsk = Objects.requireNonNull(bestAsk, "bestAsk");
            return this;
        }

        @JsonProperty(value="bestAsk")
        public final Builder bestAsk(Optional<? extends BigDecimal> bestAsk) {
            this.bestAsk = bestAsk.orElse(null);
            return this;
        }

        public final Builder bestAskSize(BigDecimal bestAskSize) {
            this.bestAskSize = Objects.requireNonNull(bestAskSize, "bestAskSize");
            return this;
        }

        @JsonProperty(value="bestAskSize")
        public final Builder bestAskSize(Optional<? extends BigDecimal> bestAskSize) {
            this.bestAskSize = bestAskSize.orElse(null);
            return this;
        }

        public final Builder lastPrice(BigDecimal lastPrice) {
            this.lastPrice = Objects.requireNonNull(lastPrice, "lastPrice");
            return this;
        }

        @JsonProperty(value="lastPrice")
        public final Builder lastPrice(Optional<? extends BigDecimal> lastPrice) {
            this.lastPrice = lastPrice.orElse(null);
            return this;
        }

        public Ticker build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTicker(this.event, this.market, this.bestBid, this.bestBidSize, this.bestAsk, this.bestAskSize, this.lastPrice);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("event");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("market");
            }
            return "Cannot build Ticker, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Ticker", generator="Immutables")
    static final class Json
    implements Ticker {
        MessageInEvent event;
        String market;
        Optional<BigDecimal> bestBid = Optional.empty();
        Optional<BigDecimal> bestBidSize = Optional.empty();
        Optional<BigDecimal> bestAsk = Optional.empty();
        Optional<BigDecimal> bestAskSize = Optional.empty();
        Optional<BigDecimal> lastPrice = Optional.empty();

        Json() {
        }

        @JsonProperty(value="event")
        public void setEvent(MessageInEvent event) {
            this.event = event;
        }

        @JsonProperty(value="market")
        public void setMarket(String market) {
            this.market = market;
        }

        @JsonProperty(value="bestBid")
        public void setBestBid(Optional<BigDecimal> bestBid) {
            this.bestBid = bestBid;
        }

        @JsonProperty(value="bestBidSize")
        public void setBestBidSize(Optional<BigDecimal> bestBidSize) {
            this.bestBidSize = bestBidSize;
        }

        @JsonProperty(value="bestAsk")
        public void setBestAsk(Optional<BigDecimal> bestAsk) {
            this.bestAsk = bestAsk;
        }

        @JsonProperty(value="bestAskSize")
        public void setBestAskSize(Optional<BigDecimal> bestAskSize) {
            this.bestAskSize = bestAskSize;
        }

        @JsonProperty(value="lastPrice")
        public void setLastPrice(Optional<BigDecimal> lastPrice) {
            this.lastPrice = lastPrice;
        }

        @Override
        public MessageInEvent getEvent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMarket() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> getBestBid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> getBestBidSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> getBestAsk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> getBestAskSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigDecimal> getLastPrice() {
            throw new UnsupportedOperationException();
        }
    }
}

