/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.github.larscom.websocket.Action;
import io.github.larscom.websocket.Channel;
import io.github.larscom.websocket.ImmutableMessageOut;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableMessageOut.class)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(as=ImmutableMessageOut.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE, overshadowImplementation=true)
public interface MessageOut {
    public Action getAction();

    public Optional<List<Channel>> getChannels();

    public Optional<String> getKey();

    public Optional<String> getSignature();

    public Optional<Long> getTimestamp();

    @Value.Check
    default public void check() {
        this.getChannels().ifPresent(channels -> {
            if (channels.isEmpty()) {
                throw new IllegalStateException("Cannot build MessageOut, some of the attributes are empty [channels]");
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableMessageOut.Builder {
    }
}

