/*
 * Decompiled with CFR 0.152.
 */
package io.github.larscom.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.larscom.websocket.Book;
import io.github.larscom.websocket.Either;
import io.github.larscom.websocket.Error;
import io.github.larscom.websocket.MessageIn;
import io.github.larscom.websocket.MessageInEvent;
import io.github.larscom.websocket.MessageOut;
import io.github.larscom.websocket.Subscription;
import io.github.larscom.websocket.Ticker;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocket
extends WebSocketClient {
    private final ObjectMapper objectMapper;
    private final CountDownLatch closeLatch;
    private final PublishSubject<Either<MessageIn, Error>> messagePublisher;
    private final HashMap<MessageInEvent, Class<? extends MessageIn>> eventMap = new HashMap<MessageInEvent, Class<? extends MessageIn>>(){
        {
            this.put(MessageInEvent.TICKER, Ticker.class);
            this.put(MessageInEvent.SUBSCRIBED, Subscription.class);
            this.put(MessageInEvent.UNSUBSCRIBED, Subscription.class);
            this.put(MessageInEvent.BOOK, Book.class);
        }
    };

    public WebSocket(ObjectMapper objectMapper) throws InterruptedException, URISyntaxException {
        super(new URI("wss://ws.bitvavo.com/v2"));
        this.objectMapper = objectMapper;
        this.closeLatch = new CountDownLatch(1);
        this.messagePublisher = PublishSubject.create();
    }

    public Flowable<Either<MessageIn, Error>> stream() {
        return this.messagePublisher.toFlowable(BackpressureStrategy.BUFFER);
    }

    public void send(MessageOut message) throws JsonProcessingException {
        this.send(this.objectMapper.writeValueAsString((Object)message));
    }

    public void blockUntilClosed() throws InterruptedException {
        if (this.isOpen()) {
            this.closeLatch.await();
            this.close();
        }
    }

    public void terminate() {
        if (this.isOpen()) {
            this.closeLatch.countDown();
            this.close();
        }
    }

    public void onMessage(String message) {
        try {
            JsonNode json = this.objectMapper.readTree(message);
            Optional<Either> maybeMessage = Optional.ofNullable(json.get("event")).map(JsonNode::asText).map(MessageInEvent::deserialize).flatMap(event -> this.tryDeserialize(message, this.eventMap.get(event))).map(Either::left);
            Optional<Either> maybeError = Optional.ofNullable(json.get("error")).flatMap(__ -> this.tryDeserialize(message, Error.class)).map(Either::right);
            Optional<Either> either = maybeMessage.or(() -> maybeError);
            either.ifPresent(arg_0 -> this.messagePublisher.onNext(arg_0));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        this.closeLatch.countDown();
    }

    public void onOpen(ServerHandshake serverHandshake) {
        if (serverHandshake.getHttpStatus() != 101) {
            Error error = Error.builder().errorCode(serverHandshake.getHttpStatus()).errorMessage(serverHandshake.getHttpStatusMessage()).build();
            this.messagePublisher.onNext(Either.right(error));
        }
    }

    public void onError(Exception e) {
        Error error = Error.builder().errorCode(0).errorMessage(e.getMessage()).build();
        this.messagePublisher.onNext(Either.right(error));
    }

    private <T> Optional<T> tryDeserialize(String json, Class<T> clazz) {
        try {
            return Optional.of(this.objectMapper.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }
}

